;;; -*- Mode:Common-Lisp; Package:TV; Base:10; Fonts:(CPTFONT HL10B HL12BI HL12B CPTFONTB)1; *Patch-File:T -*-

;1;;                     RESTRICTED RIGHTS LEGEND          *
;1;; Use, duplication, or disclosure by the Government is subject to*
;1;; restrictions as set forth in subdivision (b)(3)(ii) of the Rights in*
;1;; Technical Data and Computer Software clause at 52.227-7013.*
;1;;                   TEXAS INSTRUMENTS INCORPORATED.*
;1;;                            P.O. BOX 149149*
;1;;                         AUSTIN, TEXAS 78714-9149*
;1;;                             MS 2151*
;1;; Copyright (C) 1986, 1987, 1988, 1989 Texas Instruments Incorporated. All rights reserved.*


;-------------------------------------------------------------------------------
;;; This file written by James Rice of the Stanford University
;;; Knowledge Systems Laboratory (Rice@Sumex-Aim.Stanford.Edu)
;;; The majority of this code was written by modifying existing
;;; code belonging to TI.

;;; February 89.
;-------------------------------------------------------------------------------
;;; Just define a dummy package if CLOS is not loaded.  This should mean
;;; That these patches can be loaded onto a system which does not have CLOS
;;; loaded.

;1 TAC 08-17-89 - removing pcl support*
;1(EVAL-WHEN (COMPILE load)*
;1  (LET ((si:inhibit-fdefine-warnings t))*
;1       (IF (FIND-PACKAGE 'ticlos)*
;	1   nil*
;	1   (DEFPACKAGE ticl (:use lisp ticl)))*
;1       (IF (NOT (sys:find-system-named 'pcl t t))*
;	1   (DEFPACKAGE pcl (:use lisp))*
;	1   nil)))*

(EVAL-WHEN (COMPILE load)
  (LET ((si::inhibit-fdefine-warnings t))
       (IF (FIND-PACKAGE 'ticlos)
	   nil
	   (DEFPACKAGE ticlos (:use lisp ticl)))
       ))
;1-------------------------------------------------------------------------------*

(DEFVAR 4*dont-have-initial-space** nil
"2When this is bound to true, printing functions will not throw an initial space
 for the show-x at the beginning.  This is used because the format-concisely
 methods for some show-x things have a space at the begining so as to make them
 easier to read when they are on their own on a line, since they would
 otherwise be butted up against the scroll bar.*")


(DEFUN 4show-a-class-named* (data)
"2Allocates data for a class named Data.  If there isn't such a class then
 an undefined class show-x is allocated.*"
  (LET ((class (class-named-safe data t)))
       (IF class
	   (allocate-data 'show-clos-class class)
	   (allocate-data 'show-undefined-clos-class data))))

(DEFUN 4show-a-class* (data)
"2Allocates data to show a clos class.*"
  (allocate-data 'show-clos-class data))

(DEFUN 4coerce-class-to-name* (class)
"2Given a class or class name, coerces it into the name of the class.  Class
 make be a flavor (because of flavor classes).  The righ thing happens for
 this, as it does in the event of it being a show-x.*"
  (TYPECASE class
    (symbol class)
    (any-sort-of-clos-instance (class-name-safe class))
    (si::flavor (si::flavor-name class))
    (inspection-data (coerce-class-to-name (SEND class :data)))
    (otherwise (FERROR nil "3Cannot coerce ~S into a class name.*" class))))

(DEFVAR 4*class-options-menu**
   '(("3Slots*"
      :eval (SEND ucl::this-application :inspect-thing 'show-clos-instance-variables *flavor-data*)
      :documentation "3Inspect all slots defined by this class*")
     ("" :no-select t)
     ("3Details*"
      :eval (SEND ucl::this-application :inspect-thing 'show-clos-class-details *flavor-data*)
      :documentation "3Show more detail about this class*")
     ("" :no-select t)
     ("3Local methods*"
      :eval (SEND ucl::this-application :inspect-thing 'show-local-clos-methods *flavor-data*)
      :documentation "3Inspect methods defined locally for this class*")
     ("3All Methods*"
      :eval (SEND ucl::this-application :inspect-thing 'show-all-clos-methods *flavor-data*)
      :documentation "3Inspect methods defined for and inherited by this class*")
     ("3All Methods, Sorted*"
      :eval (SEND ucl::this-application :inspect-thing 'show-all-clos-methods-sorted *flavor-data*)
      :documentation "3Sorted version of the \" ALL METHODS\" option*")
     ("" :no-select t)
     ("3Local Generic Functions*"
      :eval (SEND ucl::this-application :inspect-thing 'show-local-clos-generic-functions *flavor-data*)
      :documentation "3Inspect generic functions defined locally for this class*")
     ("3All Generic functions*"
      :eval (SEND ucl::this-application :inspect-thing 'show-all-clos-generic-functions *flavor-data*)
      :documentation "3Inspect generic functions defined for and inherited by this class*")
     ("3All Generic functions, Sorted*"
      :eval (SEND ucl::this-application :inspect-thing 'show-all-clos-generic-functions-sorted *flavor-data*)
      :documentation "3Sorted version of the \" ALL GENERIC FUNCTIONS\" option*")
     ("" :no-select t)
     ;1; This needs better who-line doc.  How it differs from Show Class.*
     ("3SuperClasses*"
      :eval (SEND ucl::this-application :inspect-thing 'show-component-classes *flavor-data*)
      :documentation "3Inspect classes which make up this class (non-heirarchical display).*")
     ("3SubClasses*"
      :eval (SEND ucl::this-application :inspect-thing 'show-dependent-classes *flavor-data*)
      :documentation "3Inspect classes which directly or indirectly depend on this class*")
     ("" :no-select t)
     ("3Debug*"
      :eval (SEND ucl:this-application :inspect-thing 'debug-class
		  *flavor-data*)
      :documentation "3Find inconsistencies and dangerous characteristics of this class (can be slow)*")
     ("" :no-select t)
     ("3Edit*"
      :eval (SETQ call-edit t)
      :documentation "3Edit this class in a Zmacs buffer.*"))
"2The item list for the class options right button menu.*")

;1-------------------------------------------------------------------------------*

(DEFFLAVOR 4generic-middle-button-mixin* () ()
  (:documentation :mixin "3Used to add generic middle button and l-2 behaviour to
 show-x flavors.*"))

(DEFMETHOD 4(generic-middle-button-mixin :middle-button-result*) ()
"2A generic method for this flavor.*"
  (SEND self :data))

(DEFMETHOD 4(generic-middle-button-mixin :handle-mouse-click*)
	   (blip flavor-inspector)
"2A simple mouse click handler for show-x things.  It invokes the normal handlers
 for the l, l2 and m clicks..*"
  (SELECTOR (FOURTH blip) =
    (#\mouse-l-1 (SEND flavor-inspector :inspect-info-left-click))
    (#\mouse-l-2 (SEND flavor-inspector :inspect-info-left-2-click))
    (#\mouse-m-1 (SEND flavor-inspector :inspect-info-middle-click))
    (otherwise (BEEP))))

;1-------------------------------------------------------------------------------*

(DEFFLAVOR 4class-operation-mixin* () (flavor-operation-mixin)
  (:documentation :mixin "3Like flavor-operation-mixin, but for classes.
 Knows about how to put up a class options right button menu.*"))

(DEFMETHOD 4(class-operation-mixin :aux-data*) ()
"2This is defined just in case we get asked what our aux data it.  It helps
 to give reasonable behaviour in the event of being meddle buttoned on.*"
  (class-name-safe data))

(DEFMETHOD 4(class-operation-mixin :handle-mouse-click*) (blip flavor-inspector)
"2A mouse click handler that allows this mixin to pop up the class options
 menu for r-1 clicks.  L and M clicks are handled in the normal ways.*"
  (SELECTOR (FOURTH blip) =
    (#\mouse-l-1 (SEND flavor-inspector :inspect-info-left-click))
    (#\mouse-m-1 (SEND flavor-inspector :inspect-info-middle-click))
    (#\mouse-r-1 (LET ((*flavor-data* data) (call-edit nil))
                   (DECLARE (SPECIAL *flavor-data* call-edit))
                   (w:menu-choose
		     *class-options-menu*
		     :label (FORMAT nil "3Operations on ~S*"
				    (flavor-or-class-name data))
		     :scrolling-p nil)
		   (IF call-edit
		       (ED (flavor-or-class-name *flavor-data*)))
		   ))
    (t
     (BEEP))))

;1-------------------------------------------------------------------------------*

(DEFFLAVOR 4show-undefined-clos-class* ()
	   (generic-middle-button-mixin inspection-data)
  (:documentation
"3A class of show-x that knows how to display undefined classes.  This is
 important because we don't want lossage if the user opts to flavex a
 flavor/class that has not had all of its components defined yet.  None of
 the code in the class inspector (except for the stuff about method combination)
 should rely in any way on the class being fully defined/finalized/able.*"))

(DEFMETHOD 4(show-undefined-clos-class :format-concisely*) (STREAM)
"2A simple print method for undefined classes.*"
  (FORMAT stream "3Undefined Class ~S*" data))

(DEFMETHOD 4(show-undefined-clos-class :middle-button-result*) ()
"2When you middle on an undefined class you just get its name back.*"
  data)

(DEFMETHOD 4(show-undefined-clos-class :generate-item*) ()
"2Undefined classes don't have anything special about them so the item list
 generated is pretty vestigial.*"
  (VALUES
     `()
     ;1;Make the label display the class name.*
     `(:font fonts:hl12bi :string ,(FORMAT nil "3Undefined Class ~s*" data))))

(DEFMETHOD 4(show-undefined-clos-class :help*) ()
"2We can't help much here.*"
 (FORMAT nil "
3The inspection pane you just selected is currently displaying an undefined
class ~S.  To get any more information you'll have to defclass it.  Failure to
do so will signal an error when you try to instantiate any class that refers to
this one.*"
	 data))
;1-------------------------------------------------------------------------------*

(DEFFLAVOR 4show-clos-class-details* () (class-operation-mixin)
  (:documentation
"3A show-x class that shows details about its Data, which is a class.  This is
 different from the normal show-clos-class, since that just shows you its
 inheritance tree.  This tells you about the options that were used when it
 was defclassed.*"))

;1 TAC 08-17-89 - removing pcl support*
;(DEFMETHOD 4(show-clos-class-details :format-concisely*) (STREAM)
;"2When the data is a PCL class we should say so.  Otherwise we just say what*
;2 we are.*"
;  (IF (iwmc-class-p-safe data)
;      (FORMAT stream "3PCL *"))
;  (FORMAT stream "3Class ~'s details*"
;	  (LIST (allocate-data 'show-clos-class data) nil
;		(class-pretty-name data (in-history-window-p stream)))))

(DEFMETHOD 4(show-clos-class-details :format-concisely*) (STREAM)
"2Report what class we are along with details.*"
  (FORMAT stream "3Class ~'s details*"
	  (LIST (allocate-data 'show-clos-class data) nil
		(class-pretty-name data (in-history-window-p stream)))))

(DEFMETHOD 4(show-clos-class-details :middle-button-result*) ()
"2Just returns the class itself.*"
  data)

(DEFMETHOD 4(show-clos-class-details :help*) ()
"2Simple help for the details of clos classes.*"
  (LET ((class-name (class-name-safe data)))
    (FORMAT nil "
3The inspection pane you just selected is currently displaying sundry details
about the class ~S.  The right button menu will let you find out other
things about this class or related classes.*"
	    class-name)))

(DEFUN 4itemise-precedence-list* (class)
"2Given a class, turns its class-precedence-list into a collection of comma
 separated items that point to show-clos-classes.*"
  (APPLY #'APPEND
        `((:item1 instance
		  ,(allocate-data 'show-clos-class
				  (FIRST (class-precedence-list-safe class)))))
	 (LOOP for cl
	       in (MAPCAR #'(lambda (x) (allocate-data 'show-clos-class x))
			  (REST (class-precedence-list-safe class)))
	       collect `((:font 1 "3, *") (:item1 instance ,cl)))))

(DEFUN 4itemise-default-initargs* (class)
"2Itemises the default-initargs of a class.  They get returned as a load of
 items that will end up on separate lines with a space at the beginning.*"
  (LET ((args (class-default-initargs-safe class)))
       (IF args
	   (LET ((MAX (APPLY #'MAX 0 (LOOP for (x y) in args collect
					   (LENGTH (SYMBOL-NAME x))))))
		(LOOP for (init value) in args
		      collect `(,*one-space-item*
				(:item1 named-structure-value ,init)
				(:colon ,(+ 2 max))
				(:item1 named-structure-value ,value))))
	   *no-items*)))

(DEFMETHOD 4(show-clos-class-details :generate-item*) ()
"2Makes the inspector mouse-sensitive items for show-clos-class-details show-xs.*"
  (VALUES
     `(,*blank-line-item*
       ;1 TAC 08-17-89 - removing pcl support*
       (;1; *(:font 1 ,(IF (iwmc-class-p-safe data) "3PCL Class *" "3Class *"))
	(:font 1 "3Class *")
        (:item1 instance ,(allocate-data 'show-clos-class data))
	(:font 1 "3's details.*"))
       ,*blank-line-item*
       ((:font 1 "3Metaclass:                 *")
        (:item1 instance ,(allocate-data 'show-clos-class (class-of-safe data))))
       ,*blank-line-item*
       ((:font 1 "3Source File:               *")
	,(IF (AND (GET (class-name-safe data) :source-file-name)
		  (class-name-safe data))
	     (path-string-safe data)
	     (FORMAT nil "3Not Defined*")))
       ,*blank-line-item*
       ((:font 1 "3Precedence List:           *")
	,@(itemise-precedence-list data))
       ,*blank-line-item*
       ((:font 1 "3Default Initargs:*"))
       ,@(itemise-default-initargs data)
       ,*blank-line-item*
       ((:font 1 "3Documentation:*"))
       ,@(LET ((doc (CATCH-ERROR (DOCUMENTATION data) nil)))
	   (IF (AND doc (NOT (EQUAL "" doc)))
	       (break-string-into-lines doc)
	       *no-items*)))
     ;1;Make the label display the class name.*
     `(:font fonts:hl12bi :string ,(FORMAT nil "3~A*" (class-pretty-name data)))))

;1-------------------------------------------------------------------------------*

;1**************
;1 TAC 07-26-89 - moved from GENERAL-INSPECTOR *
(DEFVAR 4*general-inspector-enabled** t
  "2When true the general inspector is enabled.*")

(DEFFLAVOR 4show-clos-class* () (class-operation-mixin)
  (:documentation
"3This is the most commonly used show-x flavor in the class inspector. 
 It shows CLOS classes as an indented collection of components.*"))

(DEFMETHOD 4(show-clos-class :middle-button-result*) ()
"2Show-CLOS-Classes just return the class itsle when they get middle buttoned.*"
  data)

(DEFUN 4in-history-window-p* (STREAM)
"2Is true if we're trying to write into the inspect history window.*"
  (AND (BOUNDP '*general-inspector-enabled*)
       *general-inspector-enabled*
       (TYPEP stream 'inspect-history-window)))

(DEFUN 4class-pretty-name* (class &optional (history-window-p nil))
  (WITH-OUTPUT-TO-STRING (STREAM)
    (IF (class-name-safe class)
	(IF history-window-p
	    (FORMAT stream "3~AClass ~s*"
		    ;1; TAC 08-17-89 - removing pcl support*
		    ;1; *(IF (iwmc-class-p-safe class) "3PCL *" "")
		    "" (class-name-safe class))
	    (FORMAT stream "3~s*" (class-name-safe class)))
	(PROGN (IF history-window-p
		   (FORMAT stream "3Anonymous ~AClass *"
			   ;1; TAC 08-17-89 - removing pcl support*
			   ;1;*(IF (iwmc-class-p-safe class) "3PCL *" "")
			   "")
		   (FORMAT stream "3Anonymous *"))
	       (print-pointer class stream)))))

(DEFMETHOD 4(show-clos-class :format-concisely*) (STREAM)
  "2When this flavor is printed in the history window we say CLASS before it so
 that we know its a class, since symbols are also just printed using their
 names.  When we aren't in the history window we don't have to worry about this.*"
  (PRINC (class-pretty-name data (in-history-window-p stream)) stream))

;1**************
;1 TAC 08-04-89 - better version of this in GENERAL-INSPECTOR*
;1(defmethod (show-clos-class :who-line-doc)*

(DEFUN 4class-components* (class-name)
"2Returns a structure of the components of class-name.  This can later be turned
 into an item-list that is suitably indented for the inspector to show the
 class precedence/inheritance heirarchy.  The structure of the result of this
 function is, therefore, important.*"
  (LET ((class (IF (class-p-safe class-name)
		   class-name
		   (class-named-safe class-name t))))
       (IF class
	   (LET ((result
		   (IF class
		      `(,class-name
			,(LOOP for component in
			       (class-local-supers-safe class)
			       collect
				(IF (class-p-safe component)
				    (class-components
				      (class-name-safe component))
				    (LIST component))))
		       nil)))
		result)
	   (LIST class-name nil))))

(DEFMETHOD 4(show-clos-class :generate-item*) ()
  "2Displays a class as an indented selection of component classes.  The amount of
 indentation is used to show which class a component is actually derived from.*"
  (LET* ((class-name (class-name-safe data))
	 (all-components (class-components data))
	 text-items)
    (SETQ text-items
	  (collect-dependent-classes
	    class-name 1 all-components all-components))
    (VALUES
      `(,*blank-line-item*
	;1; TAC 08-17-89 - removing pcl support*
	(;1;*(:font 1 ,(IF (iwmc-class-p-safe data) "3PCL Class *" "3Class *"))
	 (:font 1 "3Class *")
	 (:item1 instance ,(allocate-data 'show-clos-class data))
	 (:font 1 "3's superclasses.  (Metaclass is *")
	 (:item1 instance ,(allocate-data 'show-clos-class (class-of-safe data)))
	 (:font 1 "3)*")
	 )
	,*blank-line-item*
	;1; For each component method, a mouse sensitive method name (METHOD-NAME)*
	,@(OR text-items *no-items*))
      ;1; Make the label display the class name.*
      `(:font fonts:hl12bi :string
	      ,(FORMAT nil "3~A*" (class-pretty-name data))))))

(DEFUN 4collect-dependent-classes* (class-name print-level all-components pointer)
"2Takes a list of components of class-name and turns it into a set of display
 items for the inspector.  The structure of the list All-Components is used
 to compute the indentation required in the eventual display.  This code was
 cribbed from the flavor inspector so it's a bit obscure to me.  I never write
 loops as complicated as this.*"
  (IGNORE class-name)
 `(,@(LOOP for mixin-entry in (SECOND pointer)
	   for mixin = (CAR mixin-entry)
	collect
	;1; If this entry is the first mixin...*
	`((,*space-format* ,print-level)
	  (:item1 instance
		  ,(show-a-class-named mixin)))
	append (collect-dependent-classes
		 mixin (+ 2 print-level) all-components mixin-entry))))

(DEFMETHOD 4(show-clos-class :help*) ()
"2Gives a modicum of understanding to people seeing a normal class components
 display.*"
  (LET ((class-name (class-pretty-name data)))
    (FORMAT nil "
3The inspection pane you just selected is currently displaying a heirarchy of
CLOS classes which make up the class ~A.  Indentation is used to show the
origin of each component class.  Classes displayed along the left margin are
\"direct superclasses\" of class ~A.  Classes indented further from the left
margin are \"indirect superclasses\" of ~A, inherited from its direct
superclasses.

Special case:
     Often a class will have two or more components which all supply some
     class as an inherited superclass.  In these cases, the redundant
     superclasses are flagged in the displayed heirarchy with an asterisk
     (*) next to the class name.*"
	    class-name class-name class-name)))

(DEFMETHOD 4(flavor-inspector :inspect-class*) (object)
"2A hook used by the inspect-flavor function to inspect a class rather than
 a flavor.*"
  (LET ((thing (inspect-real-value
                 `(:value ,(allocate-data 'show-clos-class object) ,history))))
    ;1; first flush item we will be inspecting*
    (inspect-flush-from-history thing history)
    (SEND history :append-item thing)
    (update-panes)))

;1-------------------------------------------------------------------------------*

;1;; Typein mode definitions for the class inspector.*
;1;; ================================================*

;1-------------------------------------------------------------------------------*

;1; In this section we define two main typein modes "Class-Names" and*
;1; "CLOS-Method-Specs".  These are a little confusing because, unlike*
;1; flavors, we get multimethods and other things that are likely to confuse what *
;1; the user types.  This means that I've done some rather strange things here.*
;1; For instance, the Class-Names typein mode actually works for GFs as well.*

;1; What I wanted was to allow th user to type any of the following:*

#||
     (class-name generic-function-name)
   or
     (class-name method-type generic-function-name)
   or
     (generic-function-name class-name)
   or
     (generic-function-name method-type class-name)
   or
     class-name generic-function-name
   or    
     class-name method-type generic-function-name
   or
     generic-function-name class-name
   or    
     generic-function-name method-type class-name

   the last four types of expressions are terminated by pressing the return key.
   method-type is one of the following:
     :after :before :case
||#

;1; and then for the right thing to happen.  (I cribbed the above from the help*
;1; on syntax string.  Hopefully this will explain some of the strangenesses*
;1; in the code below.*

(DEFFLAVOR 4class-names* () (ucl:typein-mode)
  (:default-init-plist
   :auto-complete-p t)
  (:documentation
"3A typein mode for class names.  Actually this works for generic function names as well.*"))

(DEFMETHOD 4(class-names :complete-p*) (syntax)
"2Complete the class-names typein mode whenever you've got an atom to deal with.*"
  (WHEN (MEMBER syntax '(:first-atom :function) :test #'EQ)
    "3Class Names*"))

(DEFUN 4names-a-generic-function* (x)
"2Is true if x is the name of a generic function.*"
  (AND (SYMBOLP x) (FBOUNDP x) (generic-function-p-safe (SYMBOL-FUNCTION x))))

(DEFUN 4get-recognition* (word type all-class-names)
"2Gets the recognition completion for a class.*"
  (OR (MULTIPLE-VALUE-BIND (name pkg)
	  (w::separate-name-from-package word)
	(LET ((sym (FIND-SYMBOL (STRING-UPCASE name) (OR pkg *package*))))
	     ;1;; We'll accept it if it's either a class name of a GF name.*
	     (AND sym
		  (OR (class-named-safe sym t)
		      (names-a-generic-function sym))
		  (LIST sym))))
      ;1; Prefer classes over generic-functions (is this a good idea?)*
      ;1; Look for class name completions.*
      (w::get-word-completions word all-class-names)
      (IF (AND (ticlos-p)
		(NOT *cached-ticlos-class-names*))
           ;1; We haven't got any all-class-names so try symbol completions for either a class or a GF name.*
	   (w::get-symbol-completions
	     word type
	     #'(lambda (x)
		 (OR (class-named-safe x t) (names-a-generic-function x))))
	   ;1; If all else fails just look for functions.*
	   (w::get-symbol-completions
	     word type 'names-a-generic-function))))

(DEFUN 4get-apropos* (word type all-class-names)
"2Gets the apropos part of the class names completion.*"
  (MULTIPLE-VALUE-BIND (name pkg)
    (w::separate-name-from-package word)
    (WHEN (PLUSP (LENGTH name))
      (UNLESS pkg
	(SETQ pkg *package*))
      (LET ((from-all-class-names
	      ;1; Search through all known class names (usually nil) just to see if we can match.*
	      (LOOP for class-name in all-class-names
		    when (AND (LET ((fnpkg (SYMBOL-PACKAGE class-name)))
				   (OR (EQ fnpkg pkg)
				       (MEMBER fnpkg (PACKAGE-USE-LIST pkg)
					       :test #'EQ)))
			      (SEARCH (THE string (STRING name))
				      (THE string (STRING class-name))
				      :test #'CHAR-EQUAL))
		    collect class-name)))
	   (APPEND (IF (AND (ticlos-p)
			    (NOT *cached-ticlos-class-names*))
		       ;1; We didn't have any cached class names so look for*
		       ;1; symbol completions that name classes in this package.*
		       (w::get-symbol-completions
			 word type #'(lambda (x) (class-named-safe x t)))
		       nil)
		   from-all-class-names
		   ;1;; Look for symbol completions that name generic*
		   ;1;; functions in this package.*
		   (w::get-symbol-completions
		     word type 'names-a-generic-function))))))

(DEFUN 4class-complete* (word type)
"2Completes a class spec.  This is a function, not a method so that it can be
 called from methods other than those built on class-names.  In all other
 respects it has the same contract as a normal :complete method for a
 typein mode.*"
  (LET ((all-class-names (all-class-names)))
       (CASE type
	 (:recognition (get-recognition word type all-class-names))
	 (:apropos (get-apropos word type all-class-names))
	 (:spelling-corrected
	  (MULTIPLE-VALUE-BIND (name pkg)
	      (w::separate-name-from-package word)
	    (w::spell (INTERN name pkg) all-class-names))))))

(DEFMETHOD 4(class-names :complete*) (word type)
"2Completes a class name in the appropriate way for a typein mode.*"
  (class-complete word type))

(DEFMETHOD 4(class-names :handle-typein-p*) (expression type)
"2A handle-typein-p method for class-names.  We want to handle typein if it looks
 like it might name a class or a GF.*"
  (DECLARE (VALUES self=foundp not-found-message))
  (COND ((AND (MEMBER type '(first-atom atom symbol) :test #'EQ)
	      (SYMBOLP expression)
	      (OR (AND (class-named-safe expression t)
		       (is-a-class-name-not-flavor-class expression))
		  (names-a-generic-function expression)))
	 (VALUES self ()))
	((AND (SYMBOLP expression) (BOUNDP expression) expression)
	 (SEND self :handle-typein-p (SYMBOL-VALUE expression)
	       (TYPE-OF (SYMBOL-VALUE expression))))
	(t (VALUES () (FORMAT nil "3~s is not a defined class *" expression)))))

(DEFMETHOD 4(class-names :execute*) (class-inspector)
"2When we've successfully found a class (or GF) we want to inspect it.  The
 class has already been stashed in \"-\", so all we have to do is inspect the
 righ thing depending on whether it's a class or a GF.*"
  (DECLARE (SPECIAL ucl::inhibit-results-print?))
  (IF (AND (SYMBOLP -) (BOUNDP -) - (SYMBOL-VALUE -))
      (SETQ - (SYMBOL-VALUE -)))
  (LET* ((history (SEND class-inspector :history))
	 (class
	  (inspect-real-value
	    (IF (class-named-safe - t)
	       `(:value ,(show-a-class-named -) ,history)
	       `(:value ,(allocate-data 'show-clos-generic-function-details
					(function-generic-function-safe
					  (SYMBOL-FUNCTION -))
					(function-generic-function-safe
					  (SYMBOL-FUNCTION -)))
			,history)))))
	 ;1; might not work since not eq*
    (inspect-flush-from-history class history)
    (SEND history :append-item class)
    (update-panes)
    ;1; we don't want our result to be printed.*
    (SETQ ucl::inhibit-results-print? t)))

(DEFMETHOD 4(class-names :arglist*) (symbol)
"2The arglist method for the class-names typein-mode.  Symbol might name either
 a class or a GF.  If it's a GF then we want the arglist, otherwise just say
 it's a class.*"
  (IF (AND (SYMBOLP symbol) (names-a-generic-function symbol))
      (FORMAT nil "3~S*" (ARGLIST symbol))
      (IF (AND (SYMBOLP symbol) (class-named-safe symbol t))
	  (FORMAT nil "3Class ~S*" symbol)
	  (VALUES nil (FORMAT nil "3~S is not a defined class*" symbol)))))

(DEFPARAMETER 4class-names* (MAKE-INSTANCE 'class-names)
"2The actual class-names typein mode instance.*")

;1-------------------------------------------------------------------------------*

(DEFFLAVOR 4class-instance* () (ucl:typein-mode)
  (:default-init-plist
    :auto-complete-p t)
  (:documentation
"3A typein mode for class instances.  I put this in because the flavex had one.
 I've never done anything with it.*"))

(DEFMETHOD 4(class-instance :handle-typein-p*) (expression type)
"2I don't think that this is used.*"
  (IF (AND (NOT (CONSP expression)) expression)
	   (IF (NOT (AND (SYMBOLP expression) (BOUNDP expression)))
	       (VALUES () (FORMAT nil "3~s is not a defined class*" expression))
	       (COND ((TYPEP (EVAL expression) 'any-sort-of-clos-instance)
		      (IF (AND (MEMBER type '(first-atom atom symbol)
				       :test #'EQ) (SYMBOLP expression)
			       (class-named-safe (TYPE-OF (EVAL expression)) t))
			  (VALUES self ())
			  (VALUES () (FORMAT nil "3~s is not a defined class *"
					     expression))))
		     ((AND (SYMBOLP expression) (BOUNDP expression) expression
			   (NOT (EQUAL expression (SYMBOL-VALUE expression)))
			   expression
		      )
		      (SEND self :handle-typein-p (SYMBOL-VALUE expression)
			    (TYPE-OF (SYMBOL-VALUE expression))))
		     (t (VALUES () (FORMAT nil "3~s is not a defined class*"
					   expression)))))  
	   (VALUES () (FORMAT nil "3~s is not a defined class*" expression))))

(DEFMETHOD 4(class-instance :execute*) (class-inspector)
"2I don't think that this is used.*"
  (DECLARE (SPECIAL ucl::inhibit-results-print?))
  (IF (AND (SYMBOLP -) (BOUNDP -) - (SYMBOL-VALUE -))
      (SETQ - (SYMBOL-VALUE -)))
  (LET* ((history (SEND class-inspector :history)) 
	 (class
	  (inspect-real-value
		`(:value ,(show-a-class-named (TYPE-OF (EVAL -))) ,history))))
	 ;1; Might not work since not EQ*
    (inspect-flush-from-history class history)
    (SEND history :append-item class)
    (update-panes)
    ;1; we don't want our result to be printed.*
    (SETQ ucl::inhibit-results-print? t)))

(DEFPARAMETER 4class-instance* (MAKE-INSTANCE 'class-instance))

;1-------------------------------------------------------------------------------*

(DEFFLAVOR 4clos-method-specs* () (ucl:typein-mode)
  (:default-init-plist
    :auto-complete-p t)
  (:documentation "3The typein mode that knows how to deal with clos methods.*"))

(DEFMETHOD 4(clos-method-specs :complete-p*) (syntax)
  "2We want to complete pretty well anything.*"
  (WHEN (EQ syntax :atom) "3CLOS Methods*"))

(DEFVAR 4*clos-method-types**
   '(:after :before :around) ;1; Should we really have :around???*
"2These are the types of method combination types that we're allowing in typein.
There may be others, but we don't know how to do them here.*")

(DEFUN 4read-list-from-string* (STRING)
"2We've got a string, which we'd like to read as the contents of a list, so
we just tack a pair of parens onto either end and read-from-string it.*"
  (READ-FROM-STRING (STRING-APPEND "3(*" string "3)*") nil nil))

(defun-rh 4get-clos-method-expression* ()
"2I cribbed this from the flavex.  God only knows what it's up to.  This rubout
 handler stuff is too much for me.*"
  (LET* ((first-word-start (rh-word-start 1))
	 (first-word-end (rh-word-end first-word-start))
	 (second-word-start (rh-word-start (1+ first-word-end)))
	 (second-word-end
	   (MIN (rh-word-end second-word-start) (1- (rh-typein-pointer)))))
    (VALUES
      (READ-FROM-STRING
	(rh-substring-of-buffer first-word-start first-word-end))
      (READ-FROM-STRING
	(rh-substring-of-buffer second-word-start second-word-end))
      (UNLESS (= second-word-end (1- (rh-typein-pointer)))
	(rh-word-start (1+ second-word-end) t)))))

(DEFMETHOD 4(clos-method-specs :complete-for-gf-name*)
	   (word type class-name second-word more-than-two-words?)
"2Completes Word as if it's a generic function defined on class Class-Name.
 If more-than-two-words? is specified then the user must have put in a
 :after specifier or some such.  Anyway, we try to complete the gf as being
 one of all of the gfs defined on the class.*"
  (LET* ((class (class-named-safe class-name))
	 (gfs (AND class (all-clos-generic-function-names-for-class class)))
	 (all
	  (IF class
	      (IF more-than-two-words?
		  (IF (MEMBER second-word *clos-method-types* :test #'EQ)
		      gfs
		      nil)
		  (APPEND *clos-method-types* gfs))
	      nil)))
        (WHEN class
	  (LOOP for completion in
	     (CASE type
	       (:recognition (w::get-word-completions word all))
	       (:apropos (w::list-apropos (SUBSEQ word 1) all :dont-print t))
	       (:spelling-corrected (w::spell word all)))
	     collect (ucl::first-if-list completion)))))

(DEFMETHOD 4(clos-method-specs :complete*) (word type)
"2Completes a clso-method-spec typein.  The user is allowed to type the class
 name at the beginning or the end, so we complete for a GF if we've already
 got a class, otherwise we complete for a class.*"
  (MULTIPLE-VALUE-BIND (class-name second-word more-than-two-words?)
    (SEND *standard-input* :funcall-inside-yourself
	  (FUNCTION get-clos-method-expression))
    (IF (class-named-safe class-name t)
	(SEND self :complete-for-gf-name word type
	      class-name second-word more-than-two-words?)
	(IF (names-a-generic-function class-name)
	    (class-complete
	      (IF more-than-two-words? more-than-two-words? second-word) type)
	    (FERROR nil "3~S is neither a class name or a generic function.*"
		    class-name)))))

(DEFUN 4get-method-matches* (specialisations combination)
"2Is passed the list of methods for a particular GF that are specialised by the
 class in question.  If Combination is specified, then this must match with
 the method, otherwise the method is OK.*"
  (REMOVE-IF
    #'(lambda (meth)
	(AND combination
	     (NOT (MEMBER
		   combination
		   (FUNCTION-NAME (method-function-safe meth))))))
      (REMOVE nil specialisations)))

(DEFUN 4maybe-find-clos-method* (methods combination class failure-string)
"2Given a list of methods, a combination arg (:after eg, but can be nil), a class
 and a string to return if it fails to find a match, looks at the methods for
 matches with the class as a specialiser.  If it finds multiple matches then
 it loops through asking the user which one to use.*"
  (LET ((specialisations
	 (MAPCAR #'(lambda (method) (is-specialised-by-components method class))
		 methods)))
       (LET ((matches (get-method-matches specialisations combination)))
	    (IF (REST matches)
		(LET ((meth (FIND-IF
			      #'(lambda (x)
				  (Y-OR-N-P "3~&Do you mean ~S?*"
				    (FUNCTION-NAME (method-function-safe x))))
				matches)))
		     (IF meth
			 (VALUES self nil meth)
			 (VALUES nil failure-string)))
		(IF matches
		    (VALUES self nil (FIRST matches))
		    (VALUES nil failure-string))))))

(DEFMETHOD 4(clos-method-specs :handle-typein-p*) (expression type)
"2Should we handle typein for this method spec?.  Try to read it as a method
 name.*"
  (SEND self :read-a-method-name expression type))

(DEFMETHOD 4(clos-method-specs :read-a-method-name*) (expression type)
"2Tries to read expression as a method spec.  Expression could be of the form
 (class :comb GF), (class GF), (GF :comb class) or (GF class), so we have to
 jiggle around a bit figuring out which one it is.  If we know we've got both
 a class and a GF name we can go ahead and look for a method match.*"
  (IF (NOT (CONSP expression))
      (IF (AND (SYMBOLP expression) (BOUNDP expression))
	  (IF (CONSP (SYMBOL-VALUE expression))
	      (SETQ expression
		    (CDR (SYMBOL-VALUE expression)) type ':implicit-list)
	      (SETQ expression (SYMBOL-VALUE expression)))))
  (WHEN (MEMBER type '(:implicit-list cons) :test #'EQ)
    (LET ((combination (AND (THIRD expression) (SECOND expression)))
	  (fname (IF (class-named-safe (FIRST expression) t)
		     (OR (THIRD expression) (SECOND expression))
		     (FIRST expression)))
	  (class (IF (class-named-safe (FIRST expression) t)
		     (FIRST expression)
		     (class-named-safe
		       (OR (THIRD expression) (SECOND expression)) t)))
	  (str (FORMAT ()
		 "3No method supplied.  Press META- for correct syntax.*")))
         (LET ((methods
		 (IF (AND (names-a-generic-function fname))
		     (generic-function-methods-safe
			(function-generic-function-safe (SYMBOL-FUNCTION fname)))
		     nil)))
	      (IF (AND class methods)
		  (MULTIPLE-VALUE-BIND (val ok-p meth)
		      (maybe-find-clos-method
			methods combination
			(class-named-safe class t) str)
		    (IF (NOT ok-p) (SETQ - (LIST class meth)) nil)
		    (VALUES val ok-p (IF ok-p (LIST class meth) nil)))
		  (VALUES () str))))))

(DEFMETHOD 4(clos-method-specs :execute*) (flavor-inspector)
"2Having got a method spec read in we want to inspect the method for it.  We
 previously stashed the method that we found in \"-\", so we can simply go ahead
 and inspect the method as a show-clos-method-details.*"
  (DECLARE (SPECIAL ucl::inhibit-results-print?))
  (IF (AND (SYMBOLP -) (BOUNDP -))
      (SETQ - (CDR (SYMBOL-VALUE -))))
  (LET* ((history (SEND flavor-inspector :history))
	 (method
	  (inspect-real-value
	   `(:value
	     ,(allocate-data 'show-clos-method-details (FIRST -) (SECOND -))
	     ,history))))
    (inspect-flush-from-history method history)
    (SEND history :append-item method)
    (update-panes)
    ;1; We don't want our result to be printed.*
    (SETQ ucl::inhibit-results-print? t)))

(DEFMETHOD 4(clos-method-specs :arglist*) (symbol)
"2Gets the arglist for a clos method that has been typed in.  This is just like
 reading one in for completion/execution, only once we've read it in we print
 out the arglist.*"
  (IGNORE symbol)
  (WHEN (VARIABLE-BOUNDP ucl::command-loop-typein?)
    (MULTIPLE-VALUE-BIND (class-name second-word more-than-two-words?)
	(SEND (SEND ucl::command-loop-typein? :user) :funcall-inside-yourself
	      (FUNCTION get-clos-method-expression))
      (MULTIPLE-VALUE-BIND (IGNORE ok-p meth)
	  (SEND self :read-a-method-name
		`(,class-name ,second-word
		  ,@(IF more-than-two-words? (LIST more-than-two-words?) nil))
		:implicit-list)
	(IF (AND ok-p meth)
	    (MULTIPLE-VALUE-BIND (args ret) (method-arglist-safe meth)
	      (LET ((name (FUNCTION-NAME (method-function-safe meth))))
		   (VALUES
		     (IF ret
			 (FORMAT nil "3~S ~S  ~S*" name args ret)
			 (FORMAT nil "3~S ~S*" name args))
		     nil)))
	    (VALUES () "3Not a defined method*"))))))

(DEFPARAMETER 4clos-method-specs* (MAKE-INSTANCE 'clos-method-specs)
"2This is the actual variable to hold the clos-method-specs typein-mode
 instance.*")

(DEFCOMMAND 4(flavor-inspector :help-on-syntax*) ()
  '(:names ("3Syntax Help*")
    :keys #\Meta-help
    :description "3Prints help on the processing of typed expressions.*")
  (DECLARE (SPECIAL frame))
  (LET ((window (assure-is-a-frame frame)))
  (si:with-help-stream
    (window :label "3Documentation*" :superior window)
  ;1; *(SEND self :format-message
	(FORMAT window "
3You may type any of the following expressions:
~A
-- a flavor name to inspect, terminated by pressing the RETURN key
-- a method specification to inspect.  The syntax is
     (Flavor-Name Method-Name)
   or
     (Flavor-Name Method-Type Method-Name)
   or
     Flavor-Name Method-Name
   or    
     Flavor-Name Method-Type Method-Name

   The last two types of expressions are terminated by pressing the RETURN key.
   Method-Type is one of the following:
     :AFTER :AND :AROUND :BEFORE :CASE :DEFAULT :OR :OVERRIDE :WRAPPER

While typing these expressions, you may press the SPACE Bar to complete a ~A
flavor or method name.  You may also use the Input Editor completion commands
summarized below:

   CTRL-ESCAPE  -- Recognition Completion (same as the SPACE Bar)
   CTRL-\/       -- List Recognition Completions
   SUPER-ESCAPE -- Apropos Completions (complete word as an inner substring)
   SUPER-\/      -- List Apropos Completions
   HYPER-ESCAPE -- Spelling Corrected Completion (corrects minor typos)
   HYPER-\/      -- List Spelling Corrected Completions*"

;1; value for ~A follows *
		(IF (clos-p)
		    "3For CLOS input:

-- a class name to inspect, terminated by pressing the RETURN key
-- a method specification to inspect.  The syntax is
     (Class-Name Generic-Function-Name)
   or
     (Class-Name Method-Type Generic-Function-Name)
   or
     (Generic-Function-Name Class-Name)
   or
     (Generic-Function-Name Method-Type Class-Name)
   or
     Class-Name Generic-Function-Name
   or    
     Class-Name Method-Type Generic-Function-Name
   or
     Generic-Function-Name Class-Name
   or    
     Generic-Function-Name Method-Type Class-Name

   The last four types of expressions are terminated by pressing the RETURN key.
   Method-Type is one of the following:
     :AFTER :BEFORE :CASE

For Flavors input: *
"
		    "")
		))) )

;1-------------------------------------------------------------------------------*

(DEFUN 4flavor-or-class-name* (something)
"2Returns the flavor name of a flavor or the class name of a class.*"
  (IF (TYPEP something 'si::flavor)
      (si::flavor-name something)
      (IF (AND (clos-p) (TYPEP something 'any-sort-of-clos-instance))
	  (class-name-safe something)
	  (FERROR nil "3~S is not a flavor or a class.*"))))

;1-------------------------------------------------------------------------------*

(DEFFLAVOR 4show-component-classes* () (class-operation-mixin)
  (:documentation "3A show-x flavor that shows the superclasses of a class in
 a flat manner.*"))

(DEFMETHOD 4(show-component-classes :format-concisely*) (STREAM)
"2Just print it out simply.*"
  (FORMAT stream "3~'s superclasses*"
	(LIST (allocate-data 'show-clos-class data)
	      nil (class-pretty-name data (in-history-window-p stream)))))

(DEFMETHOD 4(show-component-classes :middle-button-result*) ()
"2When we get middle buttoned on we should return the class itself.*"
  data)

(DEFMETHOD 4(show-component-classes :generate-item*) ()
  (LET* ((component-classes (CDR (class-precedence-list-safe data))))
    (VALUES
     `(,*blank-line-item*
       ("3Superclasses of class *"
        (:item1 instance ,(allocate-data 'show-clos-class data))
        "3:*")
       ,*blank-line-item*
       ,@(OR
	  (LOOP for component in component-classes
                collect
		`(,*one-space-item*
		  (:item1 instance
			  ,(allocate-data 'show-clos-class component))))
	  *no-items*))
     `(:font fonts:hl12bi :string
	     ,(FORMAT nil "3~A's superclasses*" (class-pretty-name data))))))  

(DEFMETHOD 4(show-component-classes :help*) ()
  (LET ((class-name (class-pretty-name data)))
    (FORMAT nil "
3The inspection pane you just selected is currently displaying the superclasses
which make up the class ~A.  The display does not show the class heirarchy;
for a look at the class heirarchy, type ~A followed by RETURN to the
Flavor/Class/Method prompt, or click L on any mouse sensitive display of ~A
in the Inspector.

This display is useful when you are not interested in examining the class
heirarchy but are instead interested in seeing the resultant superclasses
of a class.*"
	    class-name class-name class-name)))

;1-------------------------------------------------------------------------------*

(DEFFLAVOR 4show-dependent-classes* () (class-operation-mixin)
  (:documentation "3A show-x flavor that shows the subclasses of a class in
 a flat manner.*"))

(DEFMETHOD 4(show-dependent-classes :middle-button-result*) ()
"2When we get middle buttoned on we should return the class itself.*"
  data)

(DEFMETHOD 4(show-dependent-classes :format-concisely*) (STREAM)
"2Just print it out simply.*"
 (FORMAT stream "3~'s subclasses*"
	 (LIST (allocate-data 'show-clos-class data) nil
	       (class-pretty-name data (in-history-window-p stream)))))

(DEFMETHOD 4(show-dependent-classes :generate-item*) ()
"2I cribbed this method from the flavor inspector.  I seems to work but it's full
 of all this with-recursion stuff which seems hairy to me.  Anyway, if it works,
 don't touch it - right?...*"
  (LET* ((class-name (class-pretty-name data)))
    (VALUES
     `(,*blank-line-item*
       ((:font 1
	  "3Heirarchy of classes directly or indirectly dependent on class *")
	(:item1 instance ,(allocate-data 'show-clos-class data))
        "3:*")
       ,*blank-line-item*
       ,@(LET (items
	       classes)
	   (with-recursion
	     ((dependent-classes indentation)
	      (class-direct-subclasses-safe data) 0)
	    (DOLIST (dependent-class dependent-classes)
	      ;1;; Commented out by JPR on 3/30/89.  This doesn't*
	      ;1;; seem right.*
	      (UNLESS nil;1(member dependent-class classes :test #'eq)*
		(PUSH dependent-class classes)
		(PUSH-END
		 `((,*space-format* ,(1+ (* 2 indentation)))
		   (:item1 instance
			   ,(allocate-data 'show-clos-class dependent-class)))
		 items))
	      (recurse (class-direct-subclasses-safe dependent-class)
		       (1+ indentation))))
	   items))
     `(:font fonts:hl12bi :string
	     ,(FORMAT nil "3~A's subclasses*" class-name)))))

(DEFMETHOD 4(show-dependent-classes :help*) ()
  (LET ((class-name (class-pretty-name data)))
    (FORMAT nil "
3The inspection pane you just selected is currently displaying a heirarchy
of classes which depend on class ~A (i.e. they have ~A as a superclass).
Indentation is used to show the origin of each dependency.  Classes displayed
along the left margin are \"direct subclasses\" of class ~A.
Classes indented further from the left margin are \"indirect subclasses\" of
~A, inheriting it from the classes displayed above and to the left of them.*"
	    class-name class-name class-name class-name)))

;1-------------------------------------------------------------------------------*

(DEFFLAVOR 4show-local-clos-methods* () (class-operation-mixin)
  (:documentation "3Shows the methods defined locally on a class, i.e. the
 methods that use the class specifically as a specializer.*"))

(DEFMETHOD 4(show-local-clos-methods :format-concisely*) (STREAM)
"2Just print it out simply.*"
 (FORMAT stream "3~'s local methods*"
	 (LIST (allocate-data 'show-clos-class data) nil
	       (class-pretty-name data (in-history-window-p stream)))))

(DEFMETHOD 4(show-local-clos-methods :middle-button-result*) ()
"2When we get middle buttoned on we should return the class itself.*"
  data)

(DEFUN 4collect-clos-method-items*
       (method-table
	&optional (predicate #'(lambda (element) (IGNORE element) t)))
"2Collects a list of inspect items for the methods in method-table.  Predicate
 is used to filter the list.  This was sort of abstracted out of an extremely
 magic macro in the flavex, which I didn't understand, so I made a (simple?)
 function to do what I wanted.*"
  (LOOP for method in method-table
	when (FUNCALL predicate method)
	collect `((:item1 instance ,(allocate-data 'show-clos-method method)))
	into .collection.
	finally (RETURN .collection. nil)))

(DEFVAR 4*clos-method-display-columns**
   `((:font 2 ,(FORMAT nil "3~40A~15A~15A*" "3Method*" "3Combination*" "3Arglist*")))
"2The column headers for displaying clos methods.*") 


(DEFUN 4sort-clos-methods* (methods)
"2Sorts the list of method items for the inspector into (sort of) alpha order.*"
  (SORT (COPY-LIST methods)
	#'(lambda (x y)
	    (STRING-LESSP (princ-method x nil) (princ-method y nil)))))

(DEFMETHOD 4(show-local-clos-methods :generate-item*) ()
  (LET* (;1; Sort for readability.  There might be a better place to do the sort,*
	 ;1; for instance, always maintain a sorted entry for SHOW-METHOD in *INSPECTION-DATA*.*
	 (method-table (sort-clos-methods (class-direct-methods-safe data))))
    (MULTIPLE-VALUE-BIND (items special-comb?)
	  (collect-clos-method-items method-table)
      (VALUES
       `(,*blank-line-item*
	 ((:font 1 "3Methods defined for class *")
	  (:item1 instance ,(allocate-data 'show-clos-class data))
	  (:font 1 ,(IF special-comb?
		      "3.  * = special method combination type*"
		      "3:*")))
	  ;1;Collect the methods, excluding any GET and SET methods, which we*
	  ;1;want to list separately (for readability).*
	 ,@(IF items
	     (CONS *clos-method-display-columns* items)
	     *no-items*))
       `(:font fonts:hl12bi :string
	       ,(FORMAT () "3~A's local methods*" (class-pretty-name data)))))))

(DEFMETHOD 4(show-local-clos-methods :help*) ()
  (LET ((class-name (class-pretty-name data)))
    (FORMAT nil "
3The inspection pane you just selected is currently displaying all of the methods
local to ~A.  Local methods are methods that are defined ,which have the class
~A as one of their specializers.*"
	    class-name class-name)))

;1-------------------------------------------------------------------------------*

(DEFFLAVOR 4show-local-clos-generic-functions*
	   ()
	   (class-operation-mixin)
  (:documentation "3Shows the generic functions that name the local methods for
 the data class.*"))

(DEFMETHOD 4(show-local-clos-generic-functions :middle-button-result*) ()
"2Just returns the class when we get middle buttoned on.*"
  data)

(DEFMETHOD 4(show-local-clos-generic-functions :format-concisely*) (STREAM)
"2A simple concise format method.  Nothing special here.*"
 (FORMAT stream "3~'s local generic functions*"
	 (LIST (allocate-data 'show-clos-class data) nil
	       (class-pretty-name data (in-history-window-p stream)))))

(DEFUN 4collect-clos-generic-function-items*
       (function-table
	&optional (predicate #'(lambda (element) (IGNORE element) t)))
"2Builds up an item list for the generic functions of a clos class, given a
 list of the generic functions.  Predicate is used to filter out the ones that
 we don't need.*"
  (LOOP for generic-function in function-table
	when (FUNCALL predicate function-table)
	collect `((:item1 instance
		   ,(allocate-data 'show-clos-generic-function
				   generic-function)))
	into .collection.
	finally (RETURN .collection. nil)))

(DEFVAR 4*clos-generic-function-display-columns**
	`((:font 2 ,(FORMAT nil "3~58A~15A*" "3Function*" "3Arglist*")))
"2An item used as a header for lists of generic functions.  The magic numbers
 are the tab positions of headings.  These are somewhat sensitive to the)
 fonts being used.*") 

(DEFUN 4sort-clos-generic-functions* (generic-functions)
"2Sorts a list of generic functions so that they are in sort of alpha order.*"
  (SORT (COPY-LIST generic-functions)
	#'(lambda (x y)
	    (STRING-LESSP (princ-generic-function x nil)
			  (princ-generic-function y nil)))))

(DEFMETHOD 4(show-local-clos-generic-functions :generate-item*) ()
"2Generates the inspector item list for the display of local generic fucntions.*"
  (LET* ((class-name (class-pretty-name data))
	 ;1;Sort for readability.  There might be a better place to do the*
	 ;1;sort; for instance, always maintain a sorted entry for SHOW-METHOD*
	 ;1;in *INSPECTION-DATA*.*
	 (function-table
	   (sort-clos-generic-functions
	     (class-direct-generic-functions-safe data))))
    (MULTIPLE-VALUE-BIND (items special-comb?)
      (collect-clos-generic-function-items function-table)
      (VALUES
       `(,*blank-line-item*
	 ((:font 1 "3Generic-functions defined for class *")
	  (:item1 instance ,(allocate-data 'show-clos-class data))
	  (:font 1 ,(IF special-comb?
		      "3.  * = special method combination type*"
		      "3:*")))
	 ,@(IF items
	     (CONS *clos-generic-function-display-columns* items)
	     *no-items*))
       `(:font fonts:hl12bi :string
	       ,(FORMAT () "3~A's local generic-functions*" class-name))))))

(DEFMETHOD 4(show-local-clos-generic-functions :help*) ()
  (LET ((class-name (class-pretty-name data)))
    (FORMAT nil "
3The inspection pane you just selected is currently displaying all of the generic
functions local to ~A.  Local generic functions are the generic functions that
are associated with the class's local methods; methods ,which have the class
~A as one of their specializers.*"
	    class-name class-name)))

;1-------------------------------------------------------------------------------*

(DEFFLAVOR 4show-all-clos-methods* () (class-operation-mixin)
  (:documentation
"3Shows all of the CLOS methods associated with a class.  The display is
 separated to show the different methods provided by the different
 superclasses of Data.*"))

(DEFMETHOD 4(show-all-clos-methods :format-concisely*) (STREAM)
"2Just a simple print method.  Nothing special here.*"
 (FORMAT stream "3~'s methods (all)*"
         (LIST (allocate-data 'show-clos-class data) nil
	       (class-pretty-name data (in-history-window-p stream)))))

(DEFMETHOD 4(show-all-clos-methods :middle-button-result*) ()
"2Returns the class itself when we get middle buttoned on.*"
  data)

(DEFMETHOD 4(show-all-clos-methods :generate-item*) ()
"2Builds the item list for the display of all of the methods for a given class.
 The display is split up so that the methods contributed by each component
 superclass are shown in separate groups.  This is done in a magic loop that
 I cribbed from the flavor inspector.*"
  (VALUES
    (APPEND
      (COPY-LIST (SEND (allocate-data 'show-local-clos-methods data)
		       :generate-item))
      (LOOP with top-class-method-table
	    = (sort-clos-methods (class-direct-methods-safe data))
	    for class in (REST (class-precedence-list-safe data))
	    for class-name = (class-name-safe class)
	    for method-table
	        = (COPY-LIST (class-direct-methods-safe class data))
	    when method-table
	    append (MULTIPLE-VALUE-BIND (items special-com?)
		      (collect-clos-method-items method-table
			 #'(lambda (element)
			     (IF (MEMBER element top-class-method-table
					 :test #'EQ)
				 nil
				 (PROGN (PUSH element top-class-method-table)
					t))))
		     (IF items
		    `(,*blank-line-item*
		      ,*blank-line-item*
		      ((:font 1 "3Methods inherited from class *")
		       (:item1 instance ,(allocate-data 'show-clos-class class))
		       (:font 1 ,(IF special-com?
				     "3.  * = special method combination type*"
				     "3:*")))
		      ,@(IF items
			    (CONS *clos-method-display-columns* items)
			    *no-items*))
		    nil))))
      `(:font fonts:hl12bi :string
	      ,(FORMAT nil "3~A's methods (all)*" (class-pretty-name data)))))


(DEFMETHOD 4(show-all-clos-methods :help*) ()
  (LET ((class-name (class-pretty-name data)))
    (FORMAT nil "
3The inspection pane you just selected is currently displaying all methods
defined for or inherited by class ~A.  The methods are presented under section
headers which indicate which component class of ~A provides them.  ~A's local
methods are displayed in the first section; subsequent sections are ordered
according to precedence in ~A's class heirarchy.*"
	    class-name class-name class-name class-name)))


;1-------------------------------------------------------------------------------*

(DEFFLAVOR 4show-all-clos-methods-sorted* () (class-operation-mixin)
  (:documentation
"3Shows all of the CLOS methods defined for a given class all lumped together
 in one, sorted bunch.  This is different from the show-all-clos-methods, in
 which the methods for each superclass are shown separately
 (though also sorted).*"))

(DEFMETHOD 4(show-all-clos-methods-sorted :middle-button-result*) ()
"2Just returns the class itself.*"
  data)

(DEFMETHOD 4(show-all-clos-methods-sorted :format-concisely*) (STREAM)
"2Nothing magical here.  Just prints the class name out a little cleverly.*"
 (FORMAT stream "3~'s methods (sorted)*"
         (LIST (allocate-data 'show-clos-class data) nil
	       (class-pretty-name data (in-history-window-p stream)))))

(DEFVAR 4*clos-method-display-columns-2**
  `((:font 2 ,(FORMAT nil "3~40A~15A~15A*" "3Method*" "3Combination*" "3Arglist*")))
"2This is the item that puts a heading on the display of clos methods for a
 class.  The magic numbers tab the headings appropriately.  They are a bit
 sensitive to the fonts being used.  Maybe I should rewrite these to do some
 fancy sheet-compute-motion calculations.  Groan.  Life is too short.*")

(DEFUN 4all-clos-method-items-for-class* (the-class)
"2Given a class returns the item list for all of the clos methods associated
 with it.  It does this for all of the classes in the class precedence list.*"
  (LET ((special-comb? nil)
	(so-far nil))
       (VALUES
	  (LOOP for class in (class-precedence-list-safe the-class)
		for class-name = (class-name-safe class)
		for method-table
		    = (SET-DIFFERENCE
			(class-direct-methods-safe class the-class)
			so-far)
		do (SETQ so-far (APPEND method-table so-far))
		append (MULTIPLE-VALUE-BIND (items comb?)
			   (collect-clos-method-items method-table)
			 (WHEN comb?
			   (SETQ special-comb? t))
			 items))
	  special-comb?)))

(DEFUN 4princ-method* (method stream)
"2Prints Method to Stream.  It does so in a manner different from the method's
 normal printed representation.  It shows the class of the method too.*"
  (LET ((generic-function (method-generic-function-safe method))
	(class-name (STRING-CAPITALIZE (class-name-safe (class-of-safe method)))))
       (FORMAT stream "3~A ~S ~:S*"
	       class-name
	       (AND generic-function (fast-gf-name method))
	       (unparse-specializers-safe method))))

(DEFUN 4fast-gf-name* (method)
  (SECOND (FUNCTION-NAME (method-function-safe method))))

(DEFUN 4method-lessp-1* (x y)
"2Is true if the printed representation of x is string-lessp than y.*"
  (LET ((gfx (FORMAT nil "3~S*" (fast-gf-name x)))
	(gfy (FORMAT nil "3~S*" (fast-gf-name y))))
       (OR (STRING-LESSP gfx gfy)
	   (AND (STRING-EQUAL gfx gfy)
		(MULTIPLE-VALUE-BIND (specx combx) (unparse-specializers-safe x)
		  (MULTIPLE-VALUE-BIND (specy comby)
		      (unparse-specializers-safe y)
		    (LET ((namex (FORMAT nil "3~S*" specx))
			  (namey (FORMAT nil "3~S*" specy)))
		         (OR (STRING-LESSP namex namey)
			     (AND (STRING-EQUAL namex namey)
				  (STRING-LESSP (FORMAT nil "3~S*" combx)
						(FORMAT nil "3~S*" comby)))))))))))
(DEFUN 4method-lessp* (x y)
"2Is true if the printed representation of x is string-lessp than y.*"
  (STRING-LESSP (princ-method (SEND (THIRD (FIRST x)) :data) nil)
		(princ-method (SEND (THIRD (FIRST y)) :data) nil)))

(DEFUN 4princ-generic-function* (generic-function stream)
"2Prints Generic function to Stream.  It does so in a manner different from
 the generic function's normal printed representation.  It shows the class
 of the generic function too.*"
  (FORMAT stream "3~S*"
	  (LET ((name
		  (SECOND (FUNCTION-NAME
			    (method-function-safe
			      (FIRST (generic-function-methods-safe
				       generic-function)))))))
	       (IF (AND (CONSP name) (EQUAL :internal (FIRST name)))
		   ;1;; Special case for PCL. * 
		   ;1; TAC 08-17-89 - removing pcl support, not sure which part the comment above*
                   ;1; is for,  but neither should hurt us*
		   (generic-function-name-safe generic-function)
		   name))))

(DEFUN 4gf-lessp* (x y)
"2Is true if the printed representation of x is string-lessp than y.*"
  (STRING-LESSP (princ-generic-function (SEND (THIRD (FIRST x)) :data) nil)
		(princ-generic-function (SEND (THIRD (FIRST y)) :data) nil)))

(DEFMETHOD 4(show-all-clos-methods-sorted :generate-item*) ()
"2Generates the inspector item list for the display of all of the methods for
 a class all grouped together and sorted.*"
  (VALUES
    (MULTIPLE-VALUE-BIND
      (items special-comb?) (all-clos-method-items-for-class data)
      `(,*blank-line-item*
	((:font 1 "3All Methods of class *")
	 (:item1 instance ,(allocate-data 'show-clos-class data))
	 (:font 1
	     ,(IF special-comb? "3.  * = special method combination type*" "3:*")))
	,*blank-line-item*
	,*clos-method-display-columns-2*
	,@(SORT items #'method-lessp)))
    `(:font fonts:hl12bi :string ,(FORMAT nil "3~A's methods (sorted)*"
					  (class-pretty-name data))))) 

(DEFMETHOD 4(show-all-clos-methods-sorted :help*) ()
  (LET ((class-name (class-pretty-name data)))
    (FORMAT nil "
3The inspection pane you just selected is currently displaying all methods
defined for or inherited by class ~A.  The methods are sorted alphabetically
by generic function name and method type.  (The \"All Methods\" option provides
a more organized display of the methods.)*"
	    class-name)))

;1-------------------------------------------------------------------------------*

(DEFFLAVOR 4show-all-clos-generic-functions* () (class-operation-mixin)
  (:documentation
"3Shows all of the generic functions associated with a class.  These are the GFs
 that name the methods defined on the class and its superclasses.  The display
 is separated to show the different GFs provided by the different
 superclasses of Data.*"))

(DEFMETHOD 4(show-all-clos-generic-functions :middle-button-result*) ()
"2Returns the class itself when we get middle buttoned on.*"
  data)

(DEFMETHOD 4(show-all-clos-generic-functions :format-concisely*) (STREAM)
"2Just a simple print method.  Nothing special here.*"
 (FORMAT stream "3~'s generic functions (all)*"
	 (LIST (allocate-data 'show-clos-class data) nil
	       (class-pretty-name data (in-history-window-p stream)))))

(DEFMETHOD 4(show-all-clos-generic-functions :generate-item*) ()
"2Builds the item list for the display of all of the generic functions for
 a given class.  The display is split up so that the GFs contributed by
 each component superclass are shown in separate groups.  This is done
 in a magic loop that I cribbed from the flavor inspector.*"
  (VALUES
    (APPEND
      (COPY-LIST (SEND (allocate-data 'show-local-clos-generic-functions data)
		       :generate-item))
      (LOOP with top-class-generic-function-table
	    = (COPY-LIST (class-direct-generic-functions-safe data))
	    ;1;Modded here by JPR.*
	    for class in (REST (class-precedence-list-safe data))
	    for class-name = (class-name-safe class)
	    for generic-function-table =
	        (sort-clos-generic-functions
		  (class-direct-generic-functions-safe class))
	    when generic-function-table
	    append (MULTIPLE-VALUE-BIND (items special-com?)
		      (collect-clos-generic-function-items
			generic-function-table
			 #'(lambda (element)
			     (IF (MEMBER element
					 top-class-generic-function-table
					 :test #'EQ)
				 nil
				 (PROGN (PUSH element
					      top-class-generic-function-table)
					t))))
		     (IF items
		    `(,*blank-line-item*
		      ,*blank-line-item*
		      ((:font 1 "3Generic functions inherited from class *")
		       (:item1 instance ,(allocate-data 'show-clos-class class))
		       (:font 1 ,(IF special-com?
			     "3.  * = special generic function combination type*"
				     "3:*")))
		      ,@(IF items
			    (CONS *clos-generic-function-display-columns* items)
			    *no-items*))
		    nil))))
      `(:font fonts:hl12bi :string
	      ,(FORMAT nil "3~A's generic functions (all)*"
		       (class-pretty-name data)))))

(DEFMETHOD 4(show-all-clos-generic-functions :help*) ()
  (LET ((class-name (class-pretty-name data)))
    (FORMAT nil "
3The inspection pane you just selected is currently displaying all generic
functions associated with methods defined for or inherited by class ~A.  
The generic-functions are presented under section headers which indicate which
component class of ~A provides them.  ~A's local generic functions are displayed
in the first section; subsequent sections are ordered according to precedence
in ~A's class heirarchy.*"
	    class-name class-name class-name class-name)))

;1-------------------------------------------------------------------------------*

(DEFFLAVOR 4show-all-clos-generic-functions-sorted* () (class-operation-mixin)
  (:documentation
"3Shows all of the Generic Functions defined for a given class all
 lumped together in one, sorted bunch.  This is different from the
 show-all-clos-generic-functions, in which the GFs for each superclass
 are shown separately (though also sorted).*"))

(DEFMETHOD 4(show-all-clos-generic-functions-sorted :middle-button-result*) ()
"2Just returns the class itself.*"
  data)

(DEFMETHOD 4(show-all-clos-generic-functions-sorted :format-concisely*) (STREAM)
"2Nothing magical here.  Just prints the class name out a little cleverly.*"
 (FORMAT stream "3~'s generic functions (sorted)*"
         (LIST (allocate-data 'show-clos-class data) nil
	       (class-pretty-name data (in-history-window-p stream)))))

(DEFVAR 4*clos-generic-function-display-columns-2**
	`((:font 2 ,(FORMAT nil "3~58A~15A*" "3Function*" "3Arglist*")))
"2This is the item that puts a heading on the display of Generic Functions for a
 class.  The magic numbers tab the headings appropriately.  They are a bit
 sensitive to the fonts being used.  Maybe I should rewrite these to do some
 fancy sheet-compute-motion calculations.  Groan.  Life is too short.*") 

(DEFUN 4all-clos-generic-functions-for-class* (the-class)
"2Given a class returns all of the generic functions associated with it.
 It does this for all of the classes in the class precedence list.*"
  (LET ((so-far nil))
       (LOOP for class in (class-precedence-list-safe the-class)
	     for class-name = (class-name-safe class)
	     for generic-function-table
		 = (SET-DIFFERENCE (class-direct-generic-functions-safe class)
				   so-far)
	     do (SETQ so-far (APPEND generic-function-table so-far)))
       so-far))

(DEFUN 4all-clos-generic-function-names-for-class* (the-class)
"2Returns a list of the names of all of the GFs fot The-Class.*"
  (MAPCAR #'generic-function-name-safe
	  (all-clos-generic-functions-for-class the-class)))

(DEFUN 4all-clos-generic-function-items-for-class* (the-class)
"2Given a class returns the item list for all of the generic functions associated
 with it.  It does this for all of the classes in the class precedence list.*"
  (LET ((special-comb? nil)
	(so-far nil))
       (VALUES
	 (LOOP for class in (class-precedence-list-safe the-class)
	       for class-name = (class-name-safe class)
	       for generic-function-table
	           = (SET-DIFFERENCE (class-direct-generic-functions-safe class)
				     so-far)
	       do (SETQ so-far (APPEND generic-function-table so-far))
	       append (MULTIPLE-VALUE-BIND (items comb?)
			  (collect-clos-generic-function-items
			    generic-function-table)
			(WHEN comb?
			  (SETQ special-comb? t))
			items))
	 special-comb?)))

(DEFMETHOD 4(show-all-clos-generic-functions-sorted :generate-item*) ()
"2Generates the inspector item list for the display of all of the generic
 functions for a class all grouped together and sorted.*"
  (VALUES
    (MULTIPLE-VALUE-BIND (items special-comb?)
	(all-clos-generic-function-items-for-class data)
      `(,*blank-line-item*
	((:font 1 "3All Generic-functions of class *")
	 (:item1 instance ,(allocate-data 'show-clos-class data))
	 (:font 1 ,(IF special-comb?
		       "3.  * = special generic-function combination type*" "3:*")))
	,*blank-line-item*
	,*clos-generic-function-display-columns-2*
	;1; This sorts the generic-functions alphabetically by message, then by*
	;1; generic-function type (if any), then by submessage (if any).*
	,@(SORT items #'gf-lessp)))
    `(:font fonts:hl12bi :string
	    ,(FORMAT nil "3~A's generic-functions (sorted)*"
		     (class-pretty-name data))))) 

(DEFMETHOD 4(show-all-clos-generic-functions-sorted :help*) ()
  (LET ((class-name (class-pretty-name data)))
    (FORMAT nil "
3The inspection pane you just selected is currently displaying all
generic-functions associated with all methods defined for or inherited by class
~A.  The generic-functions are sorted alphabetically by function name and
generic-function type.  (The \"All Generic-functions\" option provides a more
organized display of the generic-functions.)*"
	    class-name)))

;1-------------------------------------------------------------------------------*

(DEFVAR 4*clos-method-operations-menu**
 '(("3Inspect*" :value :inspect-clos-method
    :documentation "3Show information about this method:
slots and methods referenced, arglist, documentation, source file*")
   ("3Disassemble*" :value :disassemble-clos-method
    :documentation "3Use a standard Inspect window to show disassembled code.*")
   ("3Edit Source*" :value :edit-clos-method
    :documentation "3Edit this method in a Zmacs buffer.*")
   ("3Trace*" :value :trace-clos-method
    :documentation "3Invoke a trace window to trace this method*")
   ("3Combination*" :value :clos-method-combination
    :documentation "3Shows the method combination for this method.*")
   ("3Related Methods*" :value :related-clos-methods
    :documentation "3Show methods with the same name as this.*"))
"2The menu item list for the menu that's put up by right buttoning on a method.
 The :Value of each item in the list must be the name of a method on
 Flavor-Inspector, which takes a method as its arg.*")

(DEFFLAVOR 4show-clos-method* () (inspection-data)
  (:documentation
"3Displays a clos method.  Actually this flavor is never inspected directly,
 since whenever you click on one a show-clos-method-details is inspected.*"))

(DEFMETHOD 4(show-clos-method :aux-data*) ()
"2Just to make sure that the class gets returned rather than some strange
 method table entry.*"
  data)

(DEFMETHOD 4(show-clos-method :middle-button-result*) ()
"2Returns the class, not the method.*"  ;1; Is this right?*
  data)

(DEFUN 4merge-args-and-specialisations* (args specialisations)
"2Given a list of arg names, such as (me with) and a list of specialisations
 such as (bottle t) returns a merged version of them like ((me bottle) with).
 We don't want to show T specialisations and have to allow for the lists being
 of different lengths (though they shouldn't be.*"
  (IF specialisations
      (IF (CONSP specialisations)
	  (CONS (IF (EQUAL t (FIRST specialisations))
		    (FIRST args)
		    (LIST (FIRST args)
			  (IF (OR (SYMBOLP (FIRST specialisations))
				  (AND (CONSP (FIRST specialisations))
				       (EQUAL 'EQL
					      (FIRST (FIRST specialisations)))))
			      (FIRST specialisations)
			      (class-name-safe (FIRST specialisations)))))
		(merge-args-and-specialisations
		  (REST args) (REST specialisations)))
	  (CONS specialisations args))
      args))

(DEFVAR 4*indent1** 35
"2The number of spaces to indent between the display of a method's class
 and its generic function name.*")

(DEFVAR 4*indent2** (+ *indent1* 15)
"2The number of spaces to indent between the display of a method's generic function 
 name and its specialisers.*")

(DEFUN 4format-a-method-concisely*
       (data stream &optional (indent1 *indent1*) (indent2 *indent2*))
"2This is a slightly hairy print method for clos methods.  The reason that it's
 hairy is that we want it to be sensitive to whether the method class is
 standard-method or not and whether it's a combined method or not.*"
  (LET ((generic-function (method-generic-function-safe data))
	(class-name (STRING-CAPITALIZE
		      (class-name-safe (class-of-safe data)))))
       (LET ((gf (LIST (allocate-data 'show-clos-generic-function
				      generic-function)
		       t
		       (OR (AND generic-function
				(generic-function-name-safe generic-function))))))
	    (MULTIPLE-VALUE-BIND (specs comb) (unparse-specializers-safe data)
	     (LET ((args (merge-args-and-specialisations
			   (method-arglist-safe data) specs)))
	          (IF specs
		      (IF (standard-method-p-safe data)
			  (FORMAT stream "3~~VT~A~VT~S*"
				  gf indent1
				  (IF comb
				      (FORMAT nil "3~S~{ ~S~}*"
					      (FIRST comb) (REST comb))
				      "")
				  indent2 args)
			  (FORMAT stream "3~ ~~VT~A~VT~S*"
			       (LIST (allocate-data
				       'show-clos-class (class-of-safe data))
				     t class-name)
			       gf indent1
			       (IF comb
				   (FORMAT nil "3~S~{ ~S~}*"
					   (FIRST comb) (REST comb))
				   "")
			       indent2 args))
		      (IF (standard-method-p-safe data)
			  (FORMAT stream "3~~VT~S*" gf indent1 args)
			  (FORMAT stream "3~ ~~VT~S*"
			       (LIST (allocate-data
				       'show-clos-class (class-of-safe data))
				     t class-name)
			       gf indent1 args))))))))

(DEFMETHOD 4(show-clos-method :format-concisely*) (STREAM)
"2Prints out the method simply.  If it's being printed into the history window
 then we don't want to have any tabbing between the method class, GF and
 specialisers, otherwise we'll take the dynamically inherited tabbing.*"
  (IF (in-history-window-p stream)
      (PROGN (FORMAT stream "3CLOS Method *")
	     (format-a-method-concisely data stream 0 0))
      (PROGN (IF *dont-have-initial-space*
		 nil
		 (FORMAT stream "3 *"))
	     (format-a-method-concisely data stream))))

;1 TAC 08-04-89 - better version of this in GENERAL-INSPECTOR*
;1(defmethod (show-clos-method :who-line-doc) (ignore &optional ignore)*

(DEFMETHOD 4(flavor-inspector :inspect-clos-method*) (method)
"2Given a method, inspects its details.*"
  (SEND self :inspect-thing 'show-clos-method-details
     (FIRST (method-type-specifiers-safe method))
     method))

;1 TAC 08-04-89 - better version is in GENERAL-INSPECTOR*
;1(defmethod (flavor-inspector :disassemble-clos-method) (method)*

(DEFMETHOD 4(flavor-inspector :trace-clos-method*) (method)
"2Given a method, traces it.*"
  (trace-via-menus (FUNCTION-NAME (method-function-safe method))))

(DEFMETHOD 4(flavor-inspector :edit-clos-method*) (method)
"2Given a method, edits its source definition.*"
  (ED (FUNCTION-NAME (method-function-safe method))))

(DEFMETHOD 4(flavor-inspector :clos-method-combination*) (method)
"2Given a method, inspects its method combination representation.*"
  (SEND self :inspect-thing 'show-clos-method-combination method))

(DEFMETHOD 4(flavor-inspector :related-clos-methods*) (method)
"2Given a method, inspects the methods that are related to it.*"
  (SEND self :inspect-thing 'show-clos-related-methods method))

(DEFUN 4select-clos-method-operations*
       (method flavor-inspector current-flavor &optional selection)
"2This is the function that gets called when the user right buttons on a clos
 method.  It pops up a menu and, if the user clicks on something, invokes
 a method on the flavor inspector to process the menu selection.*"
  (IGNORE current-flavor)
  (LET ((choice
	 (OR selection
	     (ucl::smart-menu-choose
	       *clos-method-operations-menu* :label
	       (FORMAT () "3~s*"
		       (FUNCTION-NAME (method-function-safe method)))))))
       (IF choice
	   (SEND flavor-inspector choice method)
	   nil)))

(DEFMETHOD 4(show-clos-method :handle-mouse-click*) (blip flavor-inspector)
"2Handles mouse clicks for clos methods.*"
  (LET ((current-flavor (SEND (SEND (THIRD blip) :current-object) :data)))
    (SELECTOR (FOURTH blip) =
      (#\mouse-l-1
       (select-clos-method-operations
	 data flavor-inspector current-flavor :inspect-clos-method))
      (#\mouse-m-1 (SEND flavor-inspector :inspect-info-middle-click))
      (#\mouse-r-1
       (select-clos-method-operations data flavor-inspector current-flavor))
      (t (BEEP)))))

(DEFMETHOD 4(show-clos-method :generate-item*) ()
"2This isn't actually invoked (or it shouldn't be).  It's here just in case.*"
  (VALUES `(,*blank-line-item*
	    ((:font 1 "3Details of *")
	     (:item1 instance ,(allocate-data 'show-clos-method data)))
	    ,*blank-line-item*
	    ((:font 1 "3Data:      *")
	     (:item1 instance ,data)))
	  `(:font fonts:hl12bi :string
		  ,(FORMAT nil "3CLOS~{ ~s~}*" (clos-method-name data)))))

(DEFMETHOD 4(show-clos-method :help*) ()
  (FORMAT nil "
3The inspection pane you just selected is currently displaying the method ~S*"
	  data))

;1-------------------------------------------------------------------------------*

(DEFFLAVOR 4show-clos-related-methods* () (inspection-data)
  (:documentation "3Shows the methods related to the methods Data.*"))

(DEFMETHOD 4(show-clos-related-methods :middle-button-result*) ()
"2Just returns the method itself.*"
  data)

(DEFMETHOD 4(show-clos-related-methods :aux-data*) ()
"2Just returns the method itself.*"
  data)

(DEFMETHOD 4(show-clos-related-methods :format-concisely*) (STREAM)
"2Nothing special here.  Just prints out its name a little cleverly.*"
  (FORMAT stream "3Methods related to *")
  (format-a-method-concisely data stream 0 0))

(DEFMETHOD 4(show-clos-related-methods :handle-mouse-click*)
  (blip flavor-inspector)
"2Handles mouse clicks for related methods.  Knows how to do l, l2 and M clicks.*"
  (SELECTOR (FOURTH blip) =
    (#\mouse-l-1 (SEND flavor-inspector :inspect-info-left-click))
    (#\mouse-l-2 (SEND flavor-inspector :inspect-info-left-2-click))
    (#\mouse-m-1 (SEND flavor-inspector :inspect-info-middle-click))
    (otherwise (BEEP))))

(DEFMETHOD 4(show-clos-related-methods :generate-item*) ()
"2Makes an inspector item list for the methods related to Data.  This is all
 pretty simple, the methods are just displayed one on a line.*"
  (LET ((method-table
	  (sort-clos-methods
	    (generic-function-methods-safe
	      (method-generic-function-safe data)))))
       (MULTIPLE-VALUE-BIND (items ignore)
	     (collect-clos-method-items method-table)
	 (VALUES
	  `(,*blank-line-item*
	    ((:font 1 "3Methods Related to *")
	     (:item1 instance ,(allocate-data 'show-clos-method data)
		     print-unpadded-method))
	 ,*blank-line-item*
	    ,@(IF items
		(CONS *clos-method-display-columns* items)
		*no-items*))
	  `(:font fonts:hl12bi :string
		  ,(FORMAT nil "3Methods Related to CLOS~{ ~s~}*"
			(clos-method-name data)))))))

(DEFMETHOD 4(show-clos-related-methods :help*) ()
  (LET ((method-name (FUNCTION-NAME (method-function-safe data))))
    (FORMAT nil "
3The inspection pane you just selected is currently displaying methods
related to ~S.  This is all of the methods that share the same generic
function name.*"
	    method-name)))

;1-------------------------------------------------------------------------------*

(DEFUN 4print-unpadded-method* (instance stream &optional (level 0))
"2Prints a method on stream without any tabbing either before the method
 or between the GF name, the method class or the specialisers.*"
  (LET ((*indent1* 0)
        (*indent2* 0)
	(*dont-have-initial-space* t))
       (inspection-data-print-item-concisely instance stream level)))

;1-------------------------------------------------------------------------------*

;1;; Warning....  This is probably the most magical part of the CLOS inspector.*

;1-------------------------------------------------------------------------------*

(DEFFLAVOR 4show-clos-method-combination* () (inspection-data)
  (:documentation
"3Displays the methods combination call seqyuence for a given method.
 This means that the methods combination code is computed for the generic
 function named by Data (a method).  The computation of the method invokation
 sequence is extremely grungy and system dependent.*"))

(DEFMETHOD 4(show-clos-method-combination :middle-button-result*) ()
"2Just returns the method itself.*"
  data)

(DEFMETHOD 4(show-clos-method-combination :aux-data*) ()
"2Just returns the method itself.*"
  data)

(DEFMETHOD 4(show-clos-method-combination :format-concisely*) (STREAM)
"2Prints the method name out simply.  No padding is given.*"
  (FORMAT stream "3Method Combination of *")
  (format-a-method-concisely data stream 0 0))

(DEFMETHOD 4(show-clos-method-combination :handle-mouse-click*)
	   (blip flavor-inspector)
"2Handles mouse clicks for related methods.  Knows how to do l, l2 and M clicks.*"
  (SELECTOR (FOURTH blip) =
    (#\mouse-l-1 (SEND flavor-inspector :inspect-info-left-click))
    (#\mouse-l-2 (SEND flavor-inspector :inspect-info-left-2-click))
    (#\mouse-m-1 (SEND flavor-inspector :inspect-info-middle-click))
    (otherwise (BEEP))))

(DEFMETHOD 4(show-clos-method-combination :generate-item*) ()
"2Generates the mouse-sensitive inspector items for the method combination
 display.  The actual computation of the call sequence and the itemisation of
 it is done in the function method-combination-of-method-safe, which is in a
 different file.  There's lots of docs on this particular function.  After that
 itemisation has happened, this method is very simple.*"
  (VALUES
    `(,*blank-line-item*
      ((:font 1 "3Method Combination of *")
       (:item1 instance ,(allocate-data 'show-clos-method data)
	       print-unpadded-method))
      ,*blank-line-item*
      ,@(method-combination-of-method-safe data))
    `(:font fonts:hl12bi :string
	    ,(FORMAT nil "3Method call sequence of Generic Function ~S,~%~
                          when called with args of class: ~S*"
		     (generic-function-name-safe
		       (method-generic-function-safe data))
		     (unparse-specializers-safe data)))))

(DEFMETHOD 4(show-clos-method-combination :help*) ()
  (LET ((method-name (FUNCTION-NAME (method-function-safe data))))
    (FORMAT nil "
3The inspection pane you just selected is currently displaying method combination
information for ~S.  This shows as a sort of
pseudo code the way in which the overall generic function's value will be
computed it you were to call ~S with args whose types are those specified
in the specializations for ~S, i.e. ~S.*"
	    method-name (SECOND method-name) method-name
	    (unparse-specializers-safe data))))

;1-------------------------------------------------------------------------------*

(DEFFLAVOR 4show-clos-method-details*
	   () (auxiliary-data-mixin class-operation-mixin)
  (:documentation
"3Shows sundry details about clos methods, such as source file, combination and
 things like that.  Aux-data contains the method.  Data should have the class
 that caused this to be inspected, e.g. a specializer that specialises for this
 method.*"))

(DEFMETHOD 4(show-clos-method-details :middle-button-result*) ()
"2Just returns the method itself.*"
  aux-data)

(DEFMETHOD 4(show-clos-method-details :format-concisely*) (STREAM)
"2Prints the method out differently for different types of window.  If we're in
 a history window then we get the whole lot telling us that it's a CLOS method,
 otherwise we just get the method class - GF name - specializers list type of
 print out.*"
  (IF (in-history-window-p stream)
      (PROGN (FORMAT stream "3CLOS Method *")
	     (format-a-method-concisely aux-data stream 0 0))
      (PROGN (IF (NOT *dont-have-initial-space*)
		 nil
		 (FORMAT stream "3 *"))
	     (format-a-method-concisely aux-data stream))))

(DEFWRAPPER 4(show-clos-method-details :handle-mouse-click*)
	    ((blip flavor-inspector) &body body)
"2Makes sure that show clos method details things can have a right button menu.*"
  `(IF (= (FOURTH blip) #\Mouse-r-1)
       (select-clos-method-operations
	 aux-data flavor-inspector
	 (CATCH-ERROR (SEND (SEND (THIRD blip) :current-object) :data) nil))
       . ,body))

(DEFUN 4coerce-to-disassemblable-function* (something)
"2Can be passed a closure or a fef.  If it's a closure, then we want to get the
 fef for the function that defined the closure.*"
  (IF (CLOSUREP something)
      ;1; TAC 09-05-89 - substituted (si::closure-function something) for (FIRST (si:convert-closure-to-list something))*
      ;1;                      David Gray's preferred way to handle closures*
      ;1; *(FIRST (si:convert-closure-to-list something))
      (si::closure-function something)
      something))

(DEFUN 4ivars-and-messages-in-method* (FUNCTION)
"2This is a modified version of the original TI version that was in the
 flavor inspector.  The original used to return three values; the ivars
 referenced, any message keywords used and a flag that said whether there
 was a problem in computing the result.  This function now returns the
 following values:
  ivars - a list containing either symbols for the names of the flavors slots
          referenced or slot-descriptor objects for the CLOS slots referenced.
  message-keywords - as in the flavors case.
  problem - error-p as in the flavors case.
  functions-called - a list of all of the (non-generic) functions called.
  generic-functions-called - a list of all of the generic functions called.
  args - the arglist.
  returned-values - the returned values (if declared).
  locals - a list of the names of all of the locals used in the function.
  specials-read - a list of all of the specials read in the function.
  specials-bound - a list of all of the specials bound by the function,
                   including by the arglist.

 The long and the short of this is that this function is now rather misnamed,
 since it can be called with any function as its arg, be it a simple function,
 a GF, a flavors method or a CLOS method.*"
  (LET ((fef (IF (TYPEP function 'CONS) ;1; flavor method*
		 (FDEFINITION function)
		 (get-fef-from-object
		   (coerce-to-disassemblable-function function))))
	lim-pc
	ilen
	*collected-ivars*
	*collected-messages*
	*collected-functions*
	*collected-generic-functions*
	*collected-bound-specials*)
    (DECLARE
      (SPECIAL *collected-ivars* *collected-messages* *previous-op*
	       *previous-previous-op* *collected-functions*
	       *collected-generic-functions* *collected-bound-specials*))
    (DECLARE (VALUES ivars message-keywords problem functions-called
		     generic-functions-called args returned-values
		     locals specials-read specials-bound))
    (WHEN (SYMBOLP fef)	;1; Obsolete syntax for method definitions may*
      (SETF fef (SYMBOL-FUNCTION fef)))	;1; return symbols here.  PMH SPR#6810*
    (IF (CONSP fef)
	(VALUES () () (IF (EQ (CAR fef) 'MACRO) :wrapper :interpreted) nil)
	(MULTIPLE-VALUE-BIND (args returned-values) (ARGLIST fef)
	  (SETQ lim-pc (compiler:disassemble-lim-pc fef))
	  ;1; Loop through the instructions of FEF, searching for ivars and messages.*
	  (DO ((pc (fef-initial-pc fef) (+ pc ilen)))
	      ((>= pc lim-pc))
	    (SETQ ilen (search-instruction fef pc)))
	  (VALUES *collected-ivars* *collected-messages*
		  nil *collected-functions* *collected-generic-functions*
		  args returned-values
		  (SET-DIFFERENCE
		    (REMOVE nil
			    (sys::dbis-local-map (sys:get-debug-info-struct fef)))
		    args)
		  (eh::specials-used-by-fef fef)
		  *collected-bound-specials*)))))

;1; TI code, modified by JPR.*
(DEFUN 4my-decode-clos-self-ref-pointer* (fef pointer-number)
  "2Decode the pointer field of a DTP-SELF-REF-POINTER. Values are an instance variable name
 and NIL, or a component class name and T.*"
  ;1;  5/09/88 DNG - Original (adapted from FLAVOR-DECODE-SELF-REF-POINTER).*
  (DECLARE (VALUES instance-var-or-component-class t-if-component-class class slot-object))
  ;1 TAC 07-25-89 - added declare sys vars below special - compiler complains otherwise*
  (DECLARE (SPECIAL sys::local-for-first-mapping-table sys::locals-for-mapping-table-base))
  (LET* ((local-slot (LDB sys:%%clos-self-ref-mapping-table-local-index pointer-number))
	 (arg-slot (IF (= local-slot sys::local-for-first-mapping-table)
		       0
		     (- local-slot (- sys::locals-for-mapping-table-base 1))))
	 (class-name (AND (>= arg-slot 0)
			  (NTH arg-slot (compiler::function-specializers fef)))))
    (UNLESS (OR (NULL class-name)
		(NOT (FBOUNDP 'ticlos::class-named)))
      (LET ((class-object (ticlos::class-named class-name t))
	    (offset (LDB sys:%%clos-self-ref-slot-offset pointer-number)))
	(COND
	  ((NULL class-object) nil)
	  ((LDB-TEST sys:%%clos-self-ref-map-leader-flag pointer-number)
	   (VALUES (ticlos:class-name
		     (NTH offset (ticlos::class-mapped-supers class-object)))
		   t
		   (NTH offset (ticlos::class-mapped-supers class-object))
		   nil))
	  ((LDB-TEST sys:%%clos-self-ref-relocate-flag pointer-number)
	   (LET ((slot-name
		   (NTH offset (ticlos::class-mapped-slot-names class-object))))
	        (VALUES-LIST
		  (APPEND (LIST slot-name nil)
			  (REVERSE (MULTIPLE-VALUE-LIST
				     (find-slot-in-classes
				       slot-name
				       (class-precedence-list-safe class-object)
				       )))))))
	  (t nil))))))

(DEFUN 4ivar-and-class* (fef index)
"2Is passed a fef and an index into the fef.  It returns values for the name
 of the slot and the name of the arg that it was in, i.e. if the instruction,
 when disassembled would have said something like \"Slot-name in Arg-name\",
 the it returns these two names.*"
  (DECLARE (VALUES slot-name method-arg-name))
  (MULTIPLE-VALUE-BIND (slot-name ignore class slotd)
      (my-decode-clos-self-ref-pointer fef index)
    (LET ((arg-name
	    (IF (ZEROP (LDB sys:%%clos-self-ref-instance-ref-addressing-mode
			    index))
		(compiler:disassemble-arg-name
		  fef (LDB sys:%%clos-self-ref-instance-ref-index index))
		(compiler:disassemble-local-name
		  fef (LDB sys:%%clos-self-ref-instance-ref-index index)))))
      (VALUES slot-name arg-name class slotd))))

(DEFUN 4find-slot-in-classes* (name classes)
"2Given the name of a slot and a list of classes it searches the classes until it
 finds a slot of that name and then returns a slot descriptor for that slot and
 the class that defined it..*"
  (DECLARE (VALUES slotd class-defining-slot))
  (IF classes
      (LET ((entry (FIND-IF
		     #'(lambda (x)
			 (EQUAL name (slotd-name-safe x)))
		       (class-local-slots-safe (FIRST classes)))))
	   (IF entry
	       (VALUES entry (FIRST classes))
	       (find-slot-in-classes name (REST classes))))
      nil))

;1; This should no longer be used.  We've found a better way.*
(DEFUN 4find-slotd-from-fef* (slot-name fef arg-name)
"2Given the name of a slot (Slot-name) that's referenced in Fef and the name
 of the specialised arg that the slot can be found in (arg-name) it returns
 a list containing the slot-descriptor for the slot named slot-name
 (if it finds it) and the class object to which the arg-name belongs.*"
  (LET ((method
	  (OR (GETF (sys:dbis-plist (sys:get-debug-info-struct fef)) :method)
	      (LET ((methods
		      (CATCH-ERROR
			(generic-function-methods-safe
			  (function-generic-function-safe
			    (fdefinition-safe (SECOND (FUNCTION-NAME fef)))))
			nil)))
		   (FIND-IF #'(lambda (x) (EQUAL (method-function-safe x) fef))
			    methods)))))
       (IF method
	   (LET ((index
		   (POSITION arg-name (method-lambda-list-safe method))))
		(IF index
		    (LET ((class
			    (NTH index
				 (method-specializers-safe method))))
			 (LET ((match (find-slot-in-classes
					slot-name
					(class-precedence-list-safe class))))
			      (IF match (LIST match class) nil)))
		    nil))
	   nil)))

(DEFUN 4find-generic-function* (name)
"2Given the name of a GF it returns the actual generic function object named
 by Name.*"
  (GETF (sys:dbis-plist (sys:get-debug-info-struct name)) :generic-function))

;1; A couple of tests.*
;1(find-generic-function 'user:is-empty)*
;1(find-slotd-from-fef 'user:the-contents #'(ticlos:method user:fill-it2 (user:bottle t user:can)) 'user:myself)*

(DEFUN 4search-instruction* (fef pc)
"2Searches an instruction indexed by PC in the function Fef.  This is used during
 the dummy disassembling of Fef, whilst looking for interesting things about
 the function.  Particularly, it notes if the instruction is a bind type of
 instruction, since this will affect our noting of specials bound.*"
  (LET (wd op name no-reg ilen subop op-other-way)
    (SETQ ilen (compiler:disassemble-instruction-length fef pc))
    (BLOCK ()
      (SETQ wd (compiler::disassemble-fetch fef pc)
	    op (LDB si:%%qmi-full-opcode wd)
	    op-other-way (LDB (BYTE 4  9) wd)
	    subop (LDB (BYTE 3 13) wd)
	    name (AREF (compiler:instruction-decode-table) op)
	    no-reg (GET name 'compiler::no-reg))
      (LET ((*binding*
	      (OR (AND (EQUAL op-other-way 11) (< subop 3))
		  (AND (SYMBOLP name)
		       (SEARCH "3BIND*" (SYMBOL-NAME name) :test #'STRING-EQUAL)))))
	   (DECLARE (SPECIAL *binding*))
      (COND
	((EQ no-reg 'nil) ;1; does use register*
	 (search-address
	   fef (LDB si:%%qmi-register wd) (LDB si:%%qmi-offset wd) nil pc))
	((EQ name 'compiler::push-long-fef)
	 (search-address fef 0 (LDB si:%%qmi-fef-offset wd) nil pc))
	;1; Commented out by JPR on 3/02/89.  This causes occasional barfage.*
	((EQ no-reg 'CALL)
	 (CATCH-ERROR  ;1; Sometimes this doesn't work.*
	   (search-address fef (LDB (BYTE 3 6) wd) (LDB (BYTE 9 0) wd) nil)
	   nil))
	(t nil))
      ilen))))

;1 TAC 08-29-89 -  message from JPR 8/29 indicating bug in this routine. Added new condition.*
(DEFUN 4search-pointer* (fef disp pc)
"2This is called during the pseudo disassembling of Fef in order to find out
 interesting things about it.  Disp and PC are the instruction displacement
 and the pc into the Fef.  It looks for interesting things in the instruction
 and notes them by pushing the interesting thing (e.g. a special bound or a
 function called) onto a list held in a special.  There's lots of horrible
 stuff in here with lots of %%s and such.  I cribbed all of the code
 fragments from places like the disassembler so I don't understand how they
 work, but they seem to anyway.  This is a modified version of the flavor
 inspector version with extra whizz bangs added.*"
  (IGNORE pc)
  (LET (tem)
    (DECLARE
      (SPECIAL *collected-ivars* *collected-messages* *collected-functions*
	       *collected-generic-functions* *collected-bound-specials* *binding*))
    ;1; Make sure DISP argument is reasonable.*
    (UNLESS (< disp (si:%structure-boxed-size fef))
      (FERROR nil "3Offset ~d. into function is not in function ~s's boxed-Q area*" disp fef))
    (COND ((= (si:%p-data-type-offset fef disp) dtp-self-ref-pointer)
	   (IF (OR ;1; This may be a (defun foo () (declare (self-flavor bar))..*
		   ;1; fix put in by JPR on 08/29/89 11:33:46*
		   (NOT (CONSP (FUNCTION-NAME fef)))
		   (EQUAL :method (FIRST (FUNCTION-NAME fef))))
	       (MULTIPLE-VALUE-BIND (ptr component-flavor-flag)
		   (si::flavor-decode-self-ref-pointer 
		     (si::fef-flavor-name fef)
		     (si:%p-pointer-offset fef disp))
		 (WHEN ptr
		   (UNLESS component-flavor-flag
		     ;1; Collect the instance variable!!*
		     (PUSHNEW ptr *collected-ivars*))))
	       ;1; This is a CLOS instance.*
	       (MULTIPLE-VALUE-BIND (name arg-name class slotd)
		   (ivar-and-class fef (si:%p-pointer-offset fef disp))
		 (IGNORE arg-name)
		 (WHEN name
		   ;1; Collect the instance variable!!*
		   (PUSHNEW (LIST slotd class) *collected-ivars* :test #'EQUAL)))))
          ;1; Don't think this ever refers to ivars or keywords.*
          ((= (si:%p-data-type-offset fef disp) dtp-external-value-cell-pointer)
	   (LET ((tem (%p-contents-as-locative-offset fef disp)))
	        (LET ((ptr (%find-structure-header tem)))
		     (LET ((offset (%pointer-difference tem ptr)))
			      ;1; Should be %% something???*
		          (IF (AND (SYMBOLP ptr) (EQUAL offset 2))
			      (IF (generic-function-p-safe ptr)
				  (PUSHNEW (find-generic-function ptr)
					   *collected-generic-functions*)
				  (PUSHNEW ptr *collected-functions*))
			      (IF (AND (SYMBOLP ptr) (EQUAL offset 1) *binding*)
				  (PUSH ptr *collected-bound-specials*)
				  nil))))))
          (t
           (SETQ tem (%p-contents-offset fef disp))
           ;1; When argument is a keyword and the operation is a call (FUNCALL or SEND),*
	   ;1; assume it is a message.  There's also a special case caused by the popular*
	   ;1; (SEND <foo> :SEND-IF-HANDLES :bar) feature which is covered here.  *
           ;1; :BAR is included as a referenced message, even though it is technically *
	   ;1; just a keyword.*
           (WHEN (AND (SYMBOLP tem) (KEYWORDP tem))
             (PUSHNEW tem *collected-messages*))))))

(DEFUN 4referenced-symbol-details* (referenced-symbols)
"2Given a list of the symbols referenced in a fef, returns a list of items for
 the inspector, which puts a different symbol on each line with a space at
 the beginning.*"
  (CATCH-ERROR
    (IF referenced-symbols
	(LOOP for symbol in referenced-symbols
	      collect
	      `(,*one-space-item* (:item1 named-structure-value ,symbol)))
       *no-items*)
    nil))

(DEFUN 4locals-details* (locals)
"2Makes an inspector item list for the list of locals referenced in a fef.*"
  (referenced-symbol-details locals))

(DEFUN 4referenced-keywords-details* (referenced-keywords)
"2Makes an inspector item list for the list of message keywords referenced
 in a fef.*"
  (referenced-symbol-details referenced-keywords))

(DEFUN 4referenced-specials-details* (referenced-specials)
"2Makes an inspector item list for the list of specials referenced in a fef.*"
  (referenced-symbol-details referenced-specials))

(DEFUN 4bound-specials-details* (bound-specials)
"2Makes an inspector item list for the list of specials bound in a fef.*"
  (referenced-symbol-details bound-specials))

(DEFUN 4referenced-instance-variables-details* (data referenced-ivars)
"2Makes an inspector item list for the list of instance variables referenced
 in a fef.  An item in this list might be either a symbol, in which case it is
 a flavors IV name and a suitable item is made, or a list with a slot
 descriptor and class, which is the case for a clos slot reference.  In
 this case an item is made for this clos slot.*"
  data ;1; to keep compiler from complaining*
  (IF (NOT referenced-ivars)
      ;1;* TAC 08-18-891 - removing PCL support*
      ;1; *(OR (AND (iwmc-class-p-safe data) (LIST nil)) (NOT referenced-ivars))
      *no-items*
      (CATCH-ERROR
        (LOOP for entry in referenced-ivars
	      collect
	      (IF (CONSP entry)
		 `(,*one-space-item*
		   (:item1 instance
			   ,(allocate-data 'show-clos-instance-variable
					   (SECOND entry) (FIRST entry)))
		   (:font 1 "3 defined by *")
		   (:item1 instance
			   ,(allocate-data 'show-clos-class (SECOND entry))))
		 `(,*one-space-item* (:item1 named-structure-value ,entry))))
	nil)))

(DEFUN 4referenced-generic-functions-details* (referenced-generic-functions)
"2Makes an inspector item list for the list of generic functions referenced
 in a fef.*"
  (IF referenced-generic-functions
      (CATCH-ERROR
        (LOOP for function in referenced-generic-functions
	      collect `(,*one-space-item*
			(:item1
			  instance
			  ,(allocate-data 'show-clos-generic-function function))))
	nil)
      *no-items*))

(DEFUN 4referenced-functions-details* (referenced-functions)
"2Makes an inspector item list for the list of (non-generic) functions referenced
 in a fef.*"
  (IF referenced-functions
      (CATCH-ERROR
        (LOOP for function in referenced-functions
	      collect `(,*one-space-item*
			(:item1
			  instance
			  ,(allocate-data 'show-function function))))
	nil)
      *no-items*))

(DEFUN 4macros-expanded-details* (data)
"2Makes an inspector item list for the list of macros expanded by a fef.*"
  (CATCH-ERROR
    (LET ((macros
	    (MAPCAR #'ucl::first-if-list
		    (GETF (sys:dbis-plist (sys:get-debug-info-struct data))
			  :macros-expanded))))
	 (IF macros
	     (LOOP for macro in macros
		   collect
		   `(,*one-space-item* (:item1 named-structure-value ,macro)))
	     *no-items*))
    nil))

(DEFUN 4interpreted-definition-details* (fef)
"2Makes an inspector item for the interpretted definition of a fef if it can
 find one.*"
 (CATCH-ERROR
   (LET ((int (IF (CONSP fef)
		  fef
		  (IF (CONSP (sys::dbis-interpreted-definition
			       (sys:get-debug-info-struct fef)))
		      (sys::dbis-interpreted-definition
			(sys:get-debug-info-struct fef))
		      nil))))
	(IF int
	    `(((:item1 named-structure-value ,int)))
	    *no-items*))
   nil))

(DEFMETHOD 4(show-clos-method-details :generate-item*) ()
"2Makes the inspector item list for the details of a clos method.  This involves
 grovling over the diassembled code for the fef of the method and deducing
 sundry things about it, such as the specials bound or the slots accessed.
 These are all displayed in sections devoted to a particular topic, usually
 with one item on a line, e.g. on local var per line.*"
  (VALUES
    (MULTIPLE-VALUE-BIND
      (referenced-ivars referenced-keywords problem
       referenced-functions referenced-generic-functions args returned-values
       locals specials-referenced specials-bound)
	(ivars-and-messages-in-method aux-data)
      (IGNORE problem)
     `(,*blank-line-item*
       ((:font 1 "3Details of *")
	(:item1 instance
		,(allocate-data 'show-clos-method-details data aux-data)
		print-unpadded-method)
	(:font 1 "3 Class *")
	(:item1 instance
		,(allocate-data 'show-clos-class (class-of-safe aux-data))))
       ,*blank-line-item*
       ((:font 1 "3Generic Function*")
	(:colon 30)
	(:item1 instance
		,(allocate-data 'show-clos-generic-function
				(method-generic-function-safe aux-data))
		print-unpadded-method))
       ,*blank-line-item*
       ((:font 1 "3Source File*")
	(:colon 30)
	,(method-path-string-safe aux-data))
       ,*blank-line-item*
       (,(IF returned-values
	     '(:font 1 "3Arglist  Returned Values*")
	     '(:font 1 "3Arglist*"))
	(:colon 30)
	("3~:[~*()~;~S~]*" ,args ,args)
	,@(WHEN returned-values
	    `(("3  ~S*" ,returned-values))))
       ,*blank-line-item*
       ((:font 1 "3Documentation:*"))
       ,@(LET ((doc (method-docs-safe aux-data)))
	   (IF (AND doc (NOT (EQUAL "" doc)))
	       (break-string-into-lines doc)
	       *no-items*))
       ,*blank-line-item*
       ((:font 1 "3Classes Specialized:*"))
       ,@(LOOP for class in (method-parameter-specializers-safe aux-data)
	     when (class-p-safe class)
	     collect `(,*one-space-item*
		       (:item1
			 instance
			 ,(allocate-data 'show-clos-class class))))
       ,*blank-line-item*
       ;1;  TAC 08-18-89 - remove PCL support *
       ;1; ((:font 1 ,(IF (iwmc-class-p-safe aux-data)*
       ;1;*		1      ""*
       ;1;*		1      "Referenced Slots:")))*
       ((:font 1 "3Referenced Slots:*"))
       ;1;  TAC 08-18-89 - remove PCL support *
       ;1; ,@(IF (iwmc-class-p-safe aux-data)*
       ;1;*	1     nil*
       ;1;*	1     (referenced-instance-variables-details aux-data referenced-ivars))*
       ,@(referenced-instance-variables-details aux-data referenced-ivars)
       ,*blank-line-item*
       ((:font 1 "3Referenced Keywords (possibly messages passed):*"))
       ,@(referenced-keywords-details referenced-keywords)
       ,*blank-line-item*
       ((:font 1 "3Referenced Generic Functions:*"))
       ,@(referenced-generic-functions-details
	    referenced-generic-functions)
       ,*blank-line-item*
       ((:font 1 "3Referenced Functions:*"))
       ,@(referenced-functions-details referenced-functions)
       ,*blank-line-item*
       ((:font 1 "3Locals:*"))
       ,@(locals-details locals)
       ,*blank-line-item*
       ((:font 1 "3Referenced Specials:*"))
       ,@(referenced-specials-details specials-referenced)
       ,*blank-line-item*
       ((:font 1 "3Specials Bound:*"))
       ,@(bound-specials-details specials-bound)
       ,*blank-line-item*
       ((:font 1 "3Macros Expanded:*"))
       ,@(macros-expanded-details (method-function-safe aux-data))
       ,*blank-line-item*
       ((:font 1 "3Method Combination:*"))
       ,@(method-combination-of-method-safe aux-data)
       ,*blank-line-item*
       ((:font 1 "3Interpreted Definition:*"))
       ,@(interpreted-definition-details (method-function-safe aux-data))
       ))
    `(:font fonts:hl12bi :string ,(FORMAT nil "3CLOS~{ ~s~}*"
					  (clos-method-name aux-data)))))

(DEFMETHOD 4(show-clos-method-details :help*) ()
  (LET ((method-name (FUNCTION-NAME (method-function-safe aux-data))))
    (FORMAT nil "
3The inspection pane you just selected is currently displaying sundry details
about the method ~S.*"
	    method-name)))

;1-------------------------------------------------------------------------------*

(DEFFLAVOR 4show-clos-generic-function-details* ()
   (generic-middle-button-mixin auxiliary-data-mixin class-operation-mixin)
  (:documentation
"3Shows sundry details about generic functions, such as source file, methods and
 things like that.  Aux-data contains the GF.  Data should have the class
 that caused this to be inspected, e.g. a specializer that specialises a method
 for this GF.*"))

(DEFMETHOD 4(show-clos-generic-function-details :middle-button-result*) ()
"2Just returns the method itself.*"
  aux-data)

;1; TAC 08-17-89 - removing pcl support*
;(DEFMETHOD 4(show-clos-generic-function-details :format-concisely*) (STREAM)
;"2Nothing special here.  Just prints out the generic function name, noting if*
;2 it's a PCL one.*"
;  (IF (iwmc-class-p-safe data) (FORMAT stream "3PCL *") nil)
;  (FORMAT stream "3Generic function ~s*"
;	  (generic-function-name-safe aux-data)))

(DEFMETHOD 4(show-clos-generic-function-details :format-concisely*) (STREAM)
"2Nothing special here.  Just prints out the generic function name.*"
  (FORMAT stream "3Generic function ~s*"
	  (generic-function-name-safe aux-data)))

(DEFWRAPPER 4(show-clos-generic-function-details :handle-mouse-click*)
	    ((blip flavor-inspector) &body body)
"2Makes sure that show generic function details things can have a right button
 menu.*"
  `(IF (= (FOURTH blip) #\Mouse-r-1)
       (select-clos-generic-function-operations aux-data flavor-inspector
	     (CATCH-ERROR (SEND (SEND (THIRD blip) :current-object) :data) nil))
       . ,body))

;1; *** from Rice message Mods to TI-ENV-FL.-INSP.-INTERF. 8 Jun 1989 13:52:16 PDT*
(DEFUN 4compact-arglists* (arglists result)
"2Given a list of (arglist method) pairs, it accumulates into Result the
 compacted method list, which collects up all methods that share the same
 arglist.  (#<meth1> #<meth2> #<meth3>)
 -> (((args1 values1) (#<meth1>)) ((args2 values2) (#<meth2> #<meth3>))
 for methods meth2 and meth3, which share the same arglists.*"
  (IF arglists
      (LET ((match (FIND-IF #'(lambda (x)
				(EQUALP (FIRST x) (FIRST (FIRST arglists))))
			      result)))
	   (IF match
	       (compact-arglists
		 (REST arglists)
		 (CONS (LIST (FIRST match)
			     (CONS (SECOND (FIRST arglists)) (SECOND match)))
		       (REMOVE match result)))
	       (compact-arglists
		 (REST arglists)
		 (CONS (LIST (FIRST (FIRST arglists))
			     (LIST (SECOND (FIRST arglists))))
		       result))))
      result))

(DEFUN 4get-compact-arglists* (methods)
"2Returns a list of the methods Methods that have been compacted into groups
 which share the same arglists.  Thus a list of the form
 (#<meth1> #<meth2> #<meth3>)
 -> (((args1 values1) (#<meth1>)) ((args2 values2) (#<meth2> #<meth3>))
 for methods meth2 and meth3, which share the same arglists.*"
  (IF methods
      (compact-arglists
	(MAPCAR
	  #'(lambda (x)
	      (LIST (MULTIPLE-VALUE-LIST (method-arglist-safe x)) x))
	    methods)
	nil)
      nil))

(DEFUN 4generic-function-arglist-items* (gf args returned-values)
"2Returns the items for a generic funtion, whose args are Args and returned
 values are Returned values.  If the GF has any methods then the arglists of
 these are shown too, since these are usually more intelligible then that of
 the GF.*"
  (LET ((methods (generic-function-methods-safe gf)))
       (LET ((method-arglists (get-compact-arglists methods)))
	   `((,(IF returned-values
		    '(:font 1 "3Arglist  Returned Values*")
		    '(:font 1 "3Arglist*"))
	       (:colon 40)
	       ("3~:[~*()~;~S~]*" ,args ,args)
	       ,@(WHEN returned-values
		   `(("3  ~S*" ,returned-values))))
	     ,@(IF methods
		  `(,*blank-line-item*
		    ((:font 1 "3  Arglists for Methods:*"))
		    ,@(APPLY #'APPEND
			     (MAPCAR #'(lambda (x)
				  `(("3    *"
				     (:item1 t ,(FIRST (FIRST x)))
				     ,@(IF (SECOND (FIRST x))
					  `((:font 1 "3  *")
					    (:item1 t ,(SECOND (FIRST x))))
					   nil)
				     (:font 1 ,(IF (REST (SECOND x))
						   "3 for Methods*"
						   "3 for Method*")))
				    ,@(MAPCAR
					#'(lambda (meth)
					    `("	"
					      (:item1 instance
					      ,(allocate-data
						 'show-clos-method-details
						 meth meth))))
					  (SECOND x))))
			        method-arglists)))
		  nil)))))

(DEFMETHOD 4(show-clos-generic-function-details :generate-item*) ()
"2Makes the inspector item list for the details of a Generic function. 
 This involves grovling over the diassembled code for the fef of the GF
 and deducing sundry things about it, such as the specials bound or the
 slots accessed.  These are all displayed in sections devoted to a particular
 topic, usually with one item on a line, e.g. on local var per line.*"
  (VALUES
    (MULTIPLE-VALUE-BIND
      (referenced-ivars referenced-keywords problem
       referenced-functions referenced-generic-functions args returned-values
       locals specials-referenced specials-bound)
	(ivars-and-messages-in-method aux-data)
      (IGNORE problem)
     `(,*blank-line-item*
       ((:font 1 "3Details of *")
	(:item1 instance
	    ,(allocate-data 'show-clos-generic-function-details data aux-data))
	(:font 1 "3 (Class of function object *")
	(:item1 instance
		,(allocate-data 'show-clos-class (class-of-gf-safe aux-data)))
	(:font 1 "3)*"))
       ,*blank-line-item*
       ((:font 1 "3Source File*")
	(:colon 40)
       ,(path-string-1
	  (si:function-spec-get (generic-function-name-safe aux-data)
				:source-file-name)
	  'DEFUN))
       ,*blank-line-item*
       ,@(generic-function-arglist-items aux-data args returned-values)
       ,*blank-line-item*
       ((:font 1 "3Documentation:*"))
       ,@(LET ((doc (DOCUMENTATION aux-data)))
	   (IF (AND doc (NOT (EQUAL "" doc)))
	       (break-string-into-lines doc)
	       *no-items*))
       ,*blank-line-item*
       ((:font 1 "3Method Combination*")
	(:colon 40)
	("3~S*" ,(generic-function-method-combination-safe aux-data)))
       ,*blank-line-item*
       ((:font 1 "3Method Class*")
	(:colon 40)
	(:item1 instance ,(allocate-data 'show-clos-class
			      (generic-function-method-class-safe aux-data))))
       ,*blank-line-item*
       ((:font 1 "3Associated Methods:*"))
       ,@(LET ((methods (generic-function-methods-safe aux-data)))
	      (IF methods
		  (CONS *clos-method-display-columns*
			(LOOP for meth in methods collect
			      `((:item1 instance
					,(allocate-data
					   'show-clos-method-details
							data meth)))))
		  *no-items*))
       ,*blank-line-item*
       ((:font 1 "3Argument Precedence Order*")
	(:colon 40)
	("3~S*" ,(argument-precedence-order-safe aux-data)))
       ,*blank-line-item*
       ((:font 1 "3Declarations*")
	(:colon 40)
	,(IF (generic-function-declarations-safe aux-data)
	     `("3~S*" ,(generic-function-declarations-safe aux-data))
	     '(:font 2 "3 none*")))
       ,*blank-line-item*
       ;1;* TAC 08-18-891 - removing PCL support *
       ;1; *((:font 1 ,(IF (iwmc-class-p-safe aux-data)
       ;1;*		      ""
       ;1;*		      "3Referenced Slots:*")))
       ((:font 1 "3Referenced Slots:*"))
       ,@(referenced-instance-variables-details aux-data referenced-ivars)
       ,*blank-line-item*
       ((:font 1 "3Referenced Keywords (possibly messages passed):*"))
       ,@(referenced-keywords-details referenced-keywords)
       ,*blank-line-item*
       ((:font 1 "3Referenced Generic Functions:*"))
       ,@(referenced-generic-functions-details
	    referenced-generic-functions)
       ,*blank-line-item*
       ((:font 1 "3Referenced Functions:*"))
       ,@(referenced-functions-details referenced-functions)
       ,*blank-line-item*
       ((:font 1 "3Locals:*"))
       ,@(locals-details locals)
       ,*blank-line-item*
       ((:font 1 "3Referenced Specials:*"))
       ,@(referenced-specials-details specials-referenced)
       ,*blank-line-item*
       ((:font 1 "3Specials Bound:*"))
       ,@(bound-specials-details specials-bound)
       ,*blank-line-item*
       ((:font 1 "3Macros Expanded:*"))
       ,@(macros-expanded-details (get-fef-from-object aux-data))
       ,*blank-line-item*
       ((:font 1 "3Interpreted Definition:*"))
       ,@(interpreted-definition-details (get-fef-from-object aux-data))
       ))
    `(:font fonts:hl12bi :string
	    ,(FORMAT nil "3~AGeneric-function ~s*"
		     ;1; TAC 08-17-89 - removing pcl support*
		     ;1; *(IF (iwmc-class-p-safe aux-data) "3PCL *" "")
		     ""
		     (generic-function-name-safe aux-data)))))

(DEFMETHOD 4(show-clos-generic-function-details :help*) ()
  (LET ((name (generic-function-name-safe aux-data)))
    (FORMAT nil "
3The inspection pane you just selected is currently displaying sundry details
about the generic function ~S.*"
	    name)))

;1-------------------------------------------------------------------------------*

(DEFVAR 4*clos-generic-function-operations-menu**
	'(("3Inspect*" :value :inspect-generic-function
	   :documentation "3Show information about this generic-function:
slots and methods referenced, arglist, documentation, source file*"
	  )
	  ("3Disassemble*" :value :disassemble-generic-function
	   :documentation
	   "3Use a standard Inspect window to show disassembled code.*"
	  )
	  ("3Edit Source*" :value :edit-generic-function
	   :documentation "3Edit this generic-function in a Zmacs buffer.*")
	  ("3Trace*" :value :trace-generic-function
	   :documentation "3Invoke a trace window to trace this generic function*"
	  ))
"2The menu item list for the menu that's put up by right buttoning on a generic
 function.  The :Value of each item in the list must be the name of a method on
 Flavor-Inspector, which takes a generic function as its first arg and the
 associated class as its second (usually ignored).*")

(DEFFLAVOR 4show-clos-generic-function* () (inspection-data)
  (:documentation
"3Displays a generic function.  Actually this flavor is never inspected directly,
 since whenever you click on one a show-clos-generic-function-details is
 inspected.*"))

(DEFMETHOD 4(show-clos-generic-function :middle-button-result*) ()
"2Returns the class, not the GF.*"  ;1; Is this right?*
  data)

(DEFMETHOD 4(show-clos-generic-function :aux-data*) ()
"2Just to make sure that the class gets returned rather than some strange
 method table entry.*"
  data)

(DEFUN 4format-a-generic-function-concisely*
       (gf stream &optional (indent1 *indent1*) (indent2 *indent2*))
"2This is a slightly hairy print method for generic functions.  The reason that
 it's hairy is that we want it to be sensitive to whether the generic function
 class is standard-generic-function or not and whether it's a combined method
 or not.*"
  (IGNORE indent1)
  (CATCH-ERROR
    (LET ((class-name
	    (CATCH-ERROR
	      (STRING-CAPITALIZE (class-name-safe (class-of-safe gf)))
	      nil)))
         (LET ((gf-name (LIST gf t (generic-function-name-safe gf))))
	      (IF (OR (NOT class-name)
		      (directly-standard-generic-function-p-safe gf))
		  (FORMAT stream "3~~VT~S*"
			  gf-name indent2 (ARGLIST gf))
		  (FORMAT stream "3~ ~~VT~S*"
			  (LIST (class-of-safe gf) t class-name)
			  gf-name indent2 (ARGLIST gf)))))
    nil))

(DEFMETHOD 4(show-clos-generic-function :format-concisely*) (STREAM)
"2Prints out the generic function simply.  If it's being printed into the
 history window then we don't want to have any tabbing between the GF class,
 the GF name and the arglist, otherwise we'll take the dynamically inherited
 tabbing.*"
  (IF (in-history-window-p stream)
      (PROGN (FORMAT stream "3~AGeneric Function *"
		     ;1; TAC 08-17-89 - removing pcl support*
		     ;1; *(IF (iwmc-class-p-safe data) "3PCL *" ""))
		     "")
	     (format-a-generic-function-concisely data stream 0 0))
      (PROGN (IF *dont-have-initial-space*
		 nil
		 (FORMAT stream "3 *"))
	     (format-a-generic-function-concisely data stream))))

;1**************
;1 TAC 08-04-89 - better version of this in GENERAL-INSPECTOR*
;1(defmethod (show-clos-generic-function :who-line-doc) (ignore &optional ignore)*

(DEFMETHOD 4(flavor-inspector :inspect-generic-function*) (generic-function class)
"2Given a generic function inspects its details.*"
  (SEND self :inspect-thing 'show-clos-generic-function-details
	class generic-function))

;1**************
;1 TAC 08-04-89 - better version is in GENERAL-INSPECTOR*
;1(defmethod (flavor-inspector :disassemble-generic-function)*

(DEFMETHOD 4(flavor-inspector :edit-generic-function*) (generic-function class)
"2Given a generic function edits its source it.*"
  (IGNORE class)
  (ED (generic-function-name-safe generic-function)))

(DEFMETHOD 4(flavor-inspector :trace-generic-function*) (generic-function class)
"2Given a generic function traces it.*"
  (IGNORE class)
  (trace-via-menus (generic-function-name-safe generic-function)))

(DEFUN 4select-clos-generic-function-operations*
       (generic-function flavor-inspector current-class
	&optional selection)
"2This is the function that gets called when the user right buttons on a generic
 function.  It pops up a menu and, if the user clicks on something, invokes
 a method on the flavor inspector to process the menu selection.*"
  (LET ((choice
	  (OR selection
	      (ucl::smart-menu-choose
		*clos-generic-function-operations-menu* :label
		(FORMAT () "3~s*"
			(FUNCTION-NAME
			 (generic-function-name-safe generic-function)))))))
       (IF choice
	   (SEND flavor-inspector choice generic-function current-class)
	   nil)))

(DEFMETHOD 4(show-clos-generic-function :handle-mouse-click*)
	   (blip flavor-inspector)
"2Handles mouse clicks for generic functions.*"
  (LET ((current-flavor
	  (CATCH-ERROR (SEND (SEND (THIRD blip) :current-object) :data) nil)))
    (SELECTOR (FOURTH blip) =
      (#\Mouse-l-1
       (select-clos-generic-function-operations
	 data flavor-inspector
	 current-flavor :inspect-generic-function))
      (#\mouse-l-2 (SEND flavor-inspector :inspect-info-left-2-click))
      (#\mouse-m-1 (SEND flavor-inspector :inspect-info-middle-click))
       (#\Mouse-r-1
       (select-clos-generic-function-operations
	 data flavor-inspector current-flavor))
      (t (BEEP)))))

(DEFMETHOD 4(show-clos-generic-function :generate-item*) ()
"2This isn't actually invoked (or it shouldn't be).  It's here just in case.*"
  (VALUES `(,*blank-line-item*
	    ((:font 1 "3Details of *")
	     (:item1 instance
		     ,(allocate-data 'show-clos-generic-function data)))
	    ,*blank-line-item*
	    ((:font 1 "3Data:      *")
	     (:item1 instance ,data)))
	  `(:font fonts:hl12bi :string
		  ,(FORMAT nil "3CLOS~{ ~s~}*"
			   (generic-function-name-safe data)))))

(DEFMETHOD 4(show-clos-generic-function :help*) ()
  (LET ((name (generic-function-name-safe data)))
    (FORMAT nil "
3The inspection pane you just selected is currently displaying the
generic function ~S.*"
	    name)))

;1-------------------------------------------------------------------------------*

(DEFFLAVOR 4show-clos-instance-variable*
	   () (auxiliary-data-mixin class-operation-mixin)
  (:documentation
"3Shows interesting things about a clos instance variable.  Aux-data holds
 the slot descriptor.  Data holds the class that defined it.*"))

(DEFMETHOD 4(show-clos-instance-variable :format-concisely*) (STREAM)
"2Prints out differently if we're in a history window.  The it says \"Slot\"
 before the slot name, otherwise it just prints out the slot name.*"
  (IF (in-history-window-p stream)
      (FORMAT stream "3Slot ~s*" (slotd-name-safe aux-data))
      (FORMAT stream "3~s*" (slotd-name-safe aux-data))))

(DEFMETHOD 4(show-clos-instance-variable :middle-button-result*) ()
"2Returns the slot descriptor.*"
  aux-data)

(DEFMETHOD 4(show-clos-instance-variable :handle-mouse-click*)
	   (blip flavor-inspector)
"2Handles L, M and L2 clicks on slots.*"
  (SELECTOR (FOURTH blip) =
    (#\mouse-l-1 (SEND flavor-inspector :inspect-info-left-click))
    (#\mouse-l-2 (SEND flavor-inspector :inspect-info-left-2-click))
    (#\mouse-m-1 (SEND flavor-inspector :inspect-info-middle-click))
    (otherwise (BEEP))))

(DEFUN 4comma-separate* (LIST)
"2Given a list of inspector items, it returns a list of similar items only
 when the items are printed out they will apear as a comma separated list
 of mouse-sensitive items.*"
  (IF (REST list)
      (CONS (FIRST list)
	    (CONS '(:font 2 "3, *") (comma-separate (REST list))))
      (IF list
	  list
	 `((:font 2 "3none*")))))

(DEFUN 4slot-function-items* (FUNCTION slot)
"2Given a function to read something from a slot description, it turns the
 list derived from applying that function to Slot into a list of sensitive items
 that will be comma separated when they appear.*"
  (comma-separate (MAPCAR #'make-slot-function-item (FUNCALL function slot))))

(DEFMETHOD 4(show-clos-instance-variable :generate-item*) ()
"2Displays all sorts of interesting things about slots.*"
  (VALUES
   (MULTIPLE-VALUE-BIND (items special-comb?)
     (collect-clos-method-items
       (sort-clos-methods (class-direct-methods-safe data))
       #'(lambda (method) (method-references-slot method aux-data)))
     `(,*blank-line-item*
       ((:font 1 "3Defining Class*") (:colon 20)
	(:item1 instance ,(allocate-data 'show-clos-class data)))
       ,*blank-line-item*
       ((:font 1 "3Type*") (:colon 20)
	(:item1 named-structure-value ,(slotd-type-safe aux-data)))
       ,*blank-line-item*
       ((:font 1 "3Allocation*") (:colon 20)
	,@(LET ((alloc (slotd-allocation-safe aux-data)))
	       (IF (CONSP alloc)
		   `((:font 2 ,(FORMAT nil "3~A *" (FIRST alloc)))
		     (:item1 instance
			     ,(allocate-data 'show-clos-class (SECOND alloc))))
		   `((:font 2 ,(FORMAT nil "3~A*" alloc))))))
       ,*blank-line-item*
       ((:font 1 "3Documentation:*"))
       ,@(LET ((doc (DOCUMENTATION aux-data)))
	   (IF (AND doc (NOT (EQUAL "" doc)))
	       (break-string-into-lines doc)
	       *no-items*))
       ,*blank-line-item*
       ((:font 1 "3Readers*") (:colon 20)
	,@(slot-function-items 'slotd-readers-safe aux-data))
       ,*blank-line-item*
       ((:font 1 "3Writers*") (:colon 20)
	,@(slot-function-items 'slotd-accessors-safe aux-data))
       ,*blank-line-item*
       ((:font 1 "3Initform*") (:colon 20)
	(:item1 named-structure-value ,(slotd-initform-safe aux-data)))
       ,*blank-line-item*
       ((:font 1 "3Initargs*") (:colon 20)
	,@(comma-separate
	    (MAPCAR #'(lambda (x) `(:item1 named-structure-value ,x))
		    (slotd-initargs-safe aux-data))))
       ,*blank-line-item*
       ((:font 1 "3Methods of *")
	(:item1 instance ,(allocate-data 'show-clos-class data))
	(:font 1 "3 referencing slot *")
	(:item1 instance
		,(allocate-data 'show-clos-instance-variable data aux-data))
	(:font 1 ,(IF special-comb? "3.*" "3:*")))
       ,@(WHEN special-comb?
	   '(((:font 1 "3 * = special method combination type*"))))
       ,*blank-line-item* . ,(IF items
			       (CONS *clos-method-display-columns-2* items)
			       *no-items*)))
   `(:font fonts:hl12bi :string
	   ,(FORMAT () "3Slot ~S's details*" (slotd-name-safe aux-data)))))

(DEFUN 4method-references-slot* (method slotd)
"2Is true if the method Method in some way references the slot named by the
 slot descriptor Slotd.*"
  (MULTIPLE-VALUE-BIND (ivars) (ivars-and-messages-in-method method)
    (ASSOC slotd ivars)))

(DEFMETHOD 4(show-clos-instance-variable :help*) ()
  (LET ((name (slotd-name-safe data)))
    (FORMAT nil "
3The inspection pane you just selected is currently displaying sundry details
about the slot ~S.*"
	    name)))

;1-------------------------------------------------------------------------------*

(DEFFLAVOR 4show-clos-instance-variables* () (class-operation-mixin)
  (:documentation
"3Shows all of the slots for a clos class, separated by the class
 that defined them.*"))

(DEFMETHOD 4(show-clos-instance-variables :format-concisely*) (STREAM)
"2Says \"Foo's slots\" for a class named Foo.*"
  (FORMAT stream "3~'s slots*"
	  (LIST data nil (class-pretty-name data (in-history-window-p stream)))))

(DEFMETHOD 4(show-clos-instance-variables :middle-button-result*) ()
"2Returns the class itself.*"
  data)

(DEFVAR 4*clos-ivar-column-headers**
	`(:font 3 ,(FORMAT nil "3 Slot*"))
"2The heading for the display of slot names in the inspector.  Actually this is
 a bit redundant, since it doesn't do much.*")

(DEFUN 4print-object-just-as-name* (instance stream &optional (level 0))
"2If instance has a name slot then it prints that name, otherwise it prints
 the whole thing.  This allows the decoupling of the printed representation
 of something from its mouse-sensitive behaviour.  For instance, a slot accessor
 might really have the full printed preresentation \"Standard-Generic-Function
 FOO ((Self Bar))\" or some such.  This function would make it appear simply as
 FOO, only you'd get the whole thing if you moused on it.  It's rather like
 the ~ format directive.*"
  (LET ((thing (OR (name-safe (SEND instance :data)) instance)))
       (inspection-data-print-item-concisely thing stream level)))

;1------------------------------------------------------------------------------*

(DEFUN 4make-slot-function-item* (fn)
"2Makes an inspector item for a slot reader/writer/accessor function, Fn.
 Fn can be either a symbol that names a function or a cons that names a setf
 method.*"
  `(:item1 instance
	  ,(allocate-data 'show-clos-generic-function
			  (get-gf-for-slot-function fn))
	   print-object-just-as-name))

(DEFUN 4item-for-slot-function* (slot key name)
"2For a slot descriptor Slot, and a key function, which can extract, e.g., the
 reader functions from the SlotD using the key function Key, returns the
 inspector item for the functions extracted.  It there aren't any then it
 generates an item that says that there aren't any.*"
  (IF (FUNCALL key slot)
     `(,*blank-line-item*
       (:font 2 ,(STRING-APPEND "3        *" (STRING-CAPITALIZE name) "3s: *"))
       ,*blank-line-item*
       ,@(comma-separate (MAPCAR #'make-slot-function-item (FUNCALL key slot))))
     `((:font 2 ,(STRING-APPEND "3 no *" name "3s *")))))

(DEFUN 4clos-local-instance-variable-item* (slotd inherited-class)
"2Generates a big long item for a slot descriptor SlotD, which was inherited
 from the class Inherited-Class.  The item shows all of the readers, writers,
 accessors and the initform.  (They might not fit on a line, though but the
 user can always inspect the details.*"
 `(,*one-space-item*
   (:item1 instance
	   ,(allocate-data 'show-clos-instance-variable
			   inherited-class slotd))
   (:colon 30)
   ,@(item-for-slot-function slotd #'slotd-accessors-safe "3writer*")
   ,@(item-for-slot-function slotd #'slotd-readers-safe "3reader*")
   ,@(IF (EQUAL (slotd-initform-safe slotd) '(nil))
	 `((:font 2 "3 no initform *"))
	 `((:font 2 "3 Initform: *")
	   (:item1 instance
		   ,(allocate-data 'show-value (slotd-initform-safe slotd) nil))))))

(DEFUN 4flavors-local-instance-variable-item*
       (var inherited-flavor of-flavor)
"2Generates an item for instance variables inherited from a flavor.  Var is a 
 symbol that names the ivar, Inherited-Flavor is the flavor that defined the
 ivar and Of-Flavor is the flavor that is built on Inherited-Flavor.
 This was cribbed from the flavor inspector.*"
  (DECLARE (SPECIAL *init-options?*))
  (LET ((entry (FIND-IF #'(lambda (x)
			    (OR (AND (SYMBOLP x) (EQUAL x var))
				(AND (CONSP x) (EQUAL var (FIRST x)))))
			(si::flavor-local-instance-variables inherited-flavor))))
 `(,*one-space-item*
   (:item1 instance
	   ,(allocate-data 'show-instance-variable var))
   (,*space-format* ,(- 36 (symbol-string-length var)))
   ,*one-space-item*
   ,(FORMAT ()
      "3 ~:[   ~; G ~]     ~:[   ~; S ~]    ~:[   ~; I ~]    ~:[    ~; Sp ~]   *"
      (MEMBER var (si::flavor-gettable-instance-variables inherited-flavor)
	      :test #'EQ)
      (MEMBER var (si::flavor-settable-instance-variables inherited-flavor)
	      :test #'EQ)
      (MEMBER var (MAPCAR #'CDR
			  (si::flavor-inittable-instance-variables
			    inherited-flavor)) :test #'EQ)
      (MEMBER var (si::flavor-special-instance-variables inherited-flavor)
	      :test #'EQ))
   ,(IF (SYMBOLP entry)
	'(:font 2 "3unbound        *")
	`(:item1 instance ,(allocate-data 'show-value (CADR entry) 24)))
   ,*one-space-item*
   ,@(LET* ((init (INTERN var 'keyword))
	    (f-plist (si::flavor-plist of-flavor))
	    (init-plist (GETF f-plist :default-init-plist))
	    (value (GETF init-plist init)))
       (WHEN (AND value
		  (MEMBER init
			  (GETF f-plist 'si::all-inittable-instance-variables)
			  :test #'EQ))
	 (SETQ *init-options?* t)
	 `((:item1 instance ,(allocate-data 'show-value value nil))))))))

(DEFUN 4clos-local-instance-var-item-list*
       (inherited-variables inherited-class of-class)
"2Generates an item list for slots inherited from a class.  Inherited-Variables
 are slot descriptors that name the slots, Inherited-Class is the class that
 defined the slots and Of-Class is the class that is built on Inherited-Class.
 If Inherited-Class is a flavor, then the right thing happens and the slots
 are inspected as Flavors slots.*"
  (LET ((*init-options?* nil)
	(flavor-p nil)
       )
       (DECLARE (SPECIAL *init-options?*))
       (LET ((items
	       (LOOP for entry in inherited-variables
		     collect
		     (IF (slotd-p-safe entry)
			 (clos-local-instance-variable-item
			   entry inherited-class
			 )
			 (PROGN (SETQ flavor-p t)
				(flavors-local-instance-variable-item
				  (ucl::first-if-list entry)
				  (GET (class-name-safe inherited-class)
				       'si::flavor)
				  (GET (class-name-safe of-class) 'si::flavor)))))))
	    (IF flavor-p
		(IF *init-options?*
		    `((,*ivar-column-headers*
		       (:font 3 ,(FORMAT () "3~s's Initializations*"
					 (flavor-or-class-name of-class))))
		      ,@items)
		    `((,*ivar-column-headers*) ,@items))
		`((,*clos-ivar-column-headers*) ,@items)))))

(DEFMETHOD 4(show-clos-instance-variables :generate-item*) ()
"2Makes an item list for instance variables of a clos class.  The right
 thing happens if it inherits from a flavor.*"
  (LET* ((class-name (class-pretty-name data)))
    (VALUES
     `(,*blank-line-item*
       ((:font 1 "3Local to class *")
        (:item1 instance ,(allocate-data 'show-clos-class data))
	(:font 1 "3:*"))
       ,@(IF (class-local-slots-safe data)
	   (clos-local-instance-var-item-list
	     (class-local-slots-safe data) data data)
	   *no-items*)
       ,@(LOOP for cl in (REST (class-precedence-list-safe data))
               for local-vars = (class-local-slots-safe cl)
	    append
	    (WHEN local-vars
	      `(,*blank-line-item*
		((:font 1 "3Inherited from *")
                 (:item1 instance ,(allocate-data 'show-clos-class cl))
		 (:font 1 "3:*"))
		,@(clos-local-instance-var-item-list local-vars cl data)))))
     `(:font fonts:hl12bi :string
       ,(FORMAT () "3~A's slots*" class-name)))))

(DEFMETHOD 4(show-clos-instance-variables :help*) ()
  (LET ((name (class-pretty-name data)))
    (FORMAT nil "
3The inspection pane you just selected is currently displaying information
about all the slots of ~A.  This shows the names of all of the readers and
writers and shows the initform if any for the slot.  Clicking left on a slot
will show more information about that slot.  Clicking on a reader or writer
will show the generic function associated with that operation.*"
	    name)))

;1-------------------------------------------------------------------------------*

(DEFFLAVOR 4show-all-flavors-and-classes* () (inspection-data)
  ;1; Used just to make allocate-data work on it.  See reference to 'IGNORE below.*
  (:default-init-plist :data 'IGNORE)
  (:documentation
"3This is the class inspector equivalent of the show-all-flavors option in the
 flavor inspector.*"))

(DEFMETHOD 4(show-all-flavors-and-classes :middle-button-result*) ()
"2Nothing to return, so return nil.  Data isn't used i nthis flavor.*"
  nil)

(DEFMETHOD 4(show-all-flavors-and-classes :format-concisely*) (STREAM)
"2Just prints out \"All flavors and classes\" or \"All flavors\" if, for
 some reason clos isn't loaded.  The latter should never be the case in future.*"
  (FORMAT stream (IF (clos-p) "3All flavors and classes*" "3All flavors*")))

(DEFMETHOD 4(show-all-flavors-and-classes :who-line-doc*)
	   (IGNORE &optional ignore)
"2A who line doc string returning method for the display of all flavors
 and classes.*"
  (IF (clos-p)
      '(:any "3Inspect this flavor or class information*")
      '(:any "3Inspect this flavor information*")))

(DEFMETHOD 4(show-all-flavors-and-classes :handle-mouse-click*)
	   (blip flavor-inspector)
"2A very generic seeming mouse click method for this flavor.*"
  (SELECTOR (FOURTH blip) =
    (#\Mouse-l-1
     (SEND flavor-inspector :inspect-info-left-click))
    (#\Mouse-m-1
     (SEND flavor-inspector :inspect-info-middle-click))
    ;1; Could we put anything interesting on right click?  Maybe*
    ;1; Flavor-name apropos, or some complex query for locating sets of*
    ;1; flavors with common characteristics?*
    (t (BEEP))))

(DEFMETHOD 4(show-all-flavors-and-classes :generate-item*) ()
"2Generates the items for the display of flavors and classes. 
 The flavors are shown separatemy from the classes.  This whole diaplay
 could be very large.*"
  (VALUES
   `(,*blank-line-item*
     ((:font 1 "3Currently defined flavors: *"))
     ,*blank-line-item*
     ;1; Sort flavors by package, then alphabetically*
     ,@(LOOP for flavor in
	  (SORT (COPY-LIST *all-flavor-names*)
		#'(lambda (f1 f2)
		    (LET ((p1 (PACKAGE-NAME (SYMBOL-PACKAGE f1)))
			  (p2 (PACKAGE-NAME (SYMBOL-PACKAGE f2))))
		      (OR (STRING< p1 p2)
			  (AND (STRING= p1 p2) (STRING< f1 f2))))))
	  collect
	  `((:item1 instance
		    ,(allocate-data 'show-flavor (GET flavor 'si::flavor)))))
    ,@`(,*blank-line-item*
	,(IF (clos-p)
	    '((:font 1 "3Currently defined classes: *"))
	    '((:font 1 "")))
	,*blank-line-item*
	;1; Sort classes by package, then alphabetically*
	,@(LOOP for class in
		(SORT (all-class-names)
		      #'(lambda (f1 f2)
			  (LET ((p1 (PACKAGE-NAME (SYMBOL-PACKAGE f1)))
				(p2 (PACKAGE-NAME (SYMBOL-PACKAGE f2))))
			    (OR (STRING< p1 p2)
				(AND (STRING= p1 p2) (STRING< f1 f2))))))
		collect
		`((:item1 instance
			  ,(show-a-class-named class))))))
   `(:font fonts:hl12bi :string
	   ,(IF (clos-p) "3All flavors and classes*" "3All flavors*"))))

(DEFMETHOD 4(show-all-flavors-and-classes :help*) ()
  (FORMAT nil (IF (clos-p)
		  "
3The inspection pane you just selected is currently displaying all defined
flavors and CLOS classes.  The flavors and classes are sorted alphabetically,
first by symbol package, then by symbol name.  This makes it easier for you to
inspect related flavors and classes, since most related flavors and classes
share the same symbol package.*"
		  "
3The inspection pane you just selected is currently displaying all defined
flavors.  The flavors are sorted alphabetically, first by symbol package,
then by symbol name.  This makes it easier for you to inspect related flavors,
since most related flavors share the same symbol package.*")))

;1-------------------------------------------------------------------------------*

(DEFFLAVOR 4debug-class* ()
  (flavor-operation-mixin)
  (:documentation :special-purpose
"3A flavor used by the flavor inspector in order to represent a request be
 the user to execute the debug class command for a given class.  It is
 somewhat like Show-clos-class-details only it shows useful things that might
 cause the user problems like shadowed methods.*"))

(DEFMETHOD 4(debug-class :middle-button-result*) ()
  data)

(DEFMETHOD 4(debug-class :format-concisely*) (STREAM)
"2Prints the instance of Debug-Class in a simple manner.  This is used
to display the class in the inspector's history window and such like.*"
  (FORMAT stream "3~'s debug data*"
          (LIST (allocate-data 'show-clos-class data) nil
		(class-pretty-name data (in-history-window-p stream)))))

(DEFUN 4get-class-ivs* (class)
"2If passed a class this function returns values which are:
   The superclasses of the class, excluding itself
   A list of all of the slots for all of the components.*"
  (DECLARE (VALUES superclasses all-slots))
  (LET ((components (class-precedence-list-safe class)))
       (VALUES components (MAPCAR #'class-local-slots-safe components))))

(DEFUN 4get-flavor-and-class-ivs* (class)
"2Given a flavor or a class, returns two values:
   The components of the class/flavor, excluding itself
   A list of all of the instance variables/slots for all of the components.*"
  (DECLARE (VALUES superclassesor-component-flavors all-slots-or-ivs))
  (IF (GET (class-name-safe class) 'si::flavor)
      (get-ivs (GET (class-name-safe class) 'si::flavor))
      (IF (class-p-safe class) (get-class-ivs class) nil)))

(DEFUN 4find-slotd* (name class)
"2Given the name of a slot and a class, finds a slot descriptor for that class
 that has Name as its name.*"
  (FIND-IF #'(lambda (x) (EQUAL (slotd-name-safe x) name))
	   (class-local-slots-safe class)))

(DEFUN 4reslotd-ify* (clash)
"2Is passed a clashing slot specification, which is a list of the form:
  a) (slot-name clashing-with-slot-name)
  b) class that owned slot-name
  c) class that owned clashing-with-slot-name
 It returns a list just like the first, only the slots have been substitituted
 for the slot descriptors that describe them.*"
  (LIST (LIST (IF (class-p-safe (SECOND clash))
		  (find-slotd (FIRST (FIRST clash)) (SECOND clash))
		  (FIRST (FIRST clash)))
	      (IF (class-p-safe (THIRD clash))
		  (find-slotd (SECOND (FIRST clash)) (THIRD clash))
		  (SECOND (FIRST clash))))
	(SECOND clash)
	(THIRD clash)))

(DEFUN 4find-multiple-slot-definitions* (components iv-lists &rest args)
"2Given a list of the component classes/flavors and a list of the iv lists of
 these components it returns a list of the slots that clashed with one another.
 Args are extra args that get passed to find-multiple-definitions, namely
 DePackage-p.  What gets returned is a list, eahc of whose elements has the
 following structure.
  a) (slot-name clashing-with-slot-name)
  b) class that owned slot-name
  c) class that owned clashing-with-slot-name
 If the slots are slots from CLOS classes then they are represented as slot
 descriptors, otherwise as the symbols that name the ivars.*"
  (LET ((clashes
	  (APPLY #'find-multiple-definitions
	    components
	    (MAPCAR
	      #'(lambda (ivs)
		  (MAPCAR #'(lambda (x)
			      (IF (slotd-p-safe x) (slotd-name-safe x) x))
			    ivs))
		iv-lists)
	    args)))
       (MAPCAR #'reslotd-ify clashes)))

(DEFUN 4show-an-iv* (ivar-or-slotd class)
"2Given either the name of an ivar or a slot descriptor and the flavor/class
 respectively that defined the ivar or slot, it returns an allocated data
 item for that thing of the right flavor.*"
  (IF (slotd-p-safe ivar-or-slotd)
      (allocate-data 'show-clos-instance-variable class ivar-or-slotd)
      (allocate-data 'show-instance-variable
		     (IF (class-p-safe ivar-or-slotd)
			 (GET (class-name-safe ivar-or-slotd) 'si::flavor)
			 ivar-or-slotd))))

(DEFUN 4show-a-fl-or-cl* (data)
"2Allocates data to show either a flavor or a class, depending on what's needed.*"
  (IF (class-p-safe data)
      (allocate-data 'show-clos-class data)
      (allocate-data 'show-flavor data)))

(DEFUN 4in-string* (data)
"2If data is a class then it returns \" in class \", otherwise \" in flavor \".*"
  (IF (class-p-safe data)
      "3 in class *"
      "3 in flavor *"))

(DEFUN 4get-local-undefined-class-components* (class)
"2Given a class, it returns a list of all of the declared superclasses
 of the class that have not been defined.*"
  (LET ((LIST (class-precedence-list-safe class t)))
       (REMOVE-IF #'(lambda (x) (class-p-safe x)) list)))

(DEFUN 4collect-undefined-class-components* (class)
"2Given a class this function returns a list of all of the
 components of that class, which have not yet been defined, including any that
 have not been defined for superclasses of Class.*"
  (LET ((undefined-components (get-local-undefined-class-components class)))
       (LET ((result-from-components
	       (REMOVE nil (MAPCAR #'collect-undefined-class-components
				   (REMOVE class
					   (class-precedence-list-safe class))))))
            (uniqueise (APPEND (map-with-args #'LIST
				  undefined-components class)
			       (APPLY #'APPEND result-from-components))))))

(DEFUN 4primary-methods* (class)
"2Given a class returns a list of all of the primary methods defined directly
 by that class.  This helps us to find which ones have been shadowed.*"
  (LET ((all (class-direct-methods-safe class)))
       (REMOVE-IF-NOT 'method-primary-p-safe all)))

;1-----------------------------------------------------------------------------------*

(DEFUN 4shadows-p* (specs1 specs2 so-far)
"2Is true if the method spec spec1 for a primary method shadows the method
 defined by spec2.  So-far accumulates whether we currently think that
 they shadow.*"
  (IF specs1
      (IF specs2
	  (LET ((shadows (class-shadows (FIRST specs1) (FIRST specs2))))
	       (IF (EQUAL :disjoint shadows)
		   nil
		   (shadows-p (REST specs1) (REST specs2) (OR shadows so-far))))
	  so-far)
      so-far))

(DEFUN 4is-shadowed-by-any* (meth methods)
"2Is true if the primary method Meth is shadowed by any of the methods in
 Methods.  Returns the sublist of Methods that actually do shadow Meth.*"
  (LET ((meth-specs (unparse-specializers-safe meth))
	(gen (method-generic-function-safe meth)))
       (REMOVE-IF-NOT
	 #'(lambda (x)
	     (AND (EQUAL (method-generic-function-safe x) gen)
		  (shadows-p (unparse-specializers-safe x) meth-specs nil)))
	   methods)))
		 
(DEFUN 4get-shadowed-clos-methods-1* (class)
"2Gets a list of all of the methods of superclasses of Class
 that are shadowed by any class's methods.  It returns a list
 of lists, each element of which is of the form:
  a) shadowed method
  b) shadowing method
  c) shadowed superclass
  d) shadowing class.*"
  (LET ((local-primaries (primary-methods class))
	(components (REMOVE class (class-precedence-list-safe class))))
       (LET ((sub-methods
	       (MAPCAR #'(lambda (x)
			   (map-with-args 'LIST (primary-methods x) x))
		         components)))
	    (APPLY #'APPEND
		   (LOOP for (meth superclass) in (APPLY #'APPEND sub-methods)
			 when (is-shadowed-by-any meth local-primaries)
			 collect (map-with-args #'LIST
				   (is-shadowed-by-any meth local-primaries)
				   meth superclass class))))))

(DEFUN 4get-shadowed-clos-methods* (class)
"2Gets a list of all of the methods of superclasses of Class
 that are shadowed by any class's methods.  It returns a list
 of lists, each element of which is of the form:
  a) shadowed method
  b) shadowing method
  c) shadowed superclass
  d) shadowing class.*"
  (APPLY
    #'APPEND
    (MAPCAR 'get-shadowed-clos-methods-1 (class-precedence-list-safe class))))

(DEFMETHOD 4(debug-class :generate-item*) ()
"2This method generates a window item for displaying in the flavor inspector
which shows debug information associated with the class in question.
This window item is made up of a number of window items describing the state
of affairs in detail.*"
  (LET* ((class-name (class-pretty-name data))
	 (flavor (GET (class-name-safe data) 'si::flavor))
	 (class data)
         (clashes (MULTIPLE-VALUE-BIND (components ivs)
		      (get-flavor-and-class-ivs class)
		    (find-multiple-slot-definitions components ivs nil)))
	 (package-clashes (MULTIPLE-VALUE-BIND (components ivs)
			      (get-flavor-and-class-ivs class)
			    (find-multiple-slot-definitions components ivs t)))
	 (shadowed-methods (AND flavor (get-shadowed-methods flavor)))
	 (shadowed-clos-methods (get-shadowed-clos-methods class))
	 (undefined-class-components
	   (collect-undefined-class-components class))
	 (unsatisfied-flavors
	   (AND flavor (list-of-unsatisfied-required-flavors flavor)))
	 (unsatisfied-methods
	   (AND flavor (list-of-unsatisfied-required-methods flavor)))
	 (unsatisfied-ivs
	   (AND flavor (list-of-unsatisfied-required-ivs flavor))))
    (VALUES
      `(,*blank-line-item*
;1; ------------------------------*
	,@(IF clashes
	      `(((:font 1 "3Multiple declarations of the same slots for class *")
		 (:item1 instance ,(allocate-data 'show-clos-class class))
		 (:font 1 "3:*")))
	      nil)
	,@(LOOP for clash in clashes
	        append `(((:font 3 "3  *")
			  (:item1 instance
			      ,(show-an-iv (FIRST (FIRST clash)) (THIRD clash)))
			  (:font 3 ,(in-string (SECOND clash)))
			  (:item1 instance ,(show-a-fl-or-cl (SECOND clash)))
			  (:font 3 ,(in-string (THIRD clash)))
			  (:item1 instance ,(show-a-fl-or-cl (THIRD clash))))))
;1; ------------------------------*
	,@(IF package-clashes *blank-line-item*)
	,@(IF package-clashes *blank-line-item*)
	,@(IF package-clashes
	      `(((:font 1 "3Declarations of slots with the same PName but are in different packages for class *")
		 (:item1 instance ,(allocate-data 'show-clos-class class))
		 (:font 1 "3:*")))
	      nil)
	,@(LOOP for clash in package-clashes
	        append `(((:font 3 "3  *")
			  (:item1 instance
			    ,(show-an-iv (FIRST (FIRST clash)) (SECOND clash)))
			  (:font 3 ,(in-string (SECOND clash)))
			  (:item1 instance ,(show-a-fl-or-cl (SECOND clash)))
			  (:font 3 "3 and *")
			  (:item1 instance
			    ,(show-an-iv (SECOND (FIRST clash)) (THIRD clash)))
			  (:font 3 ,(in-string (THIRD clash)))
			  (:item1 instance ,(show-a-fl-or-cl (THIRD clash))))))
;1; ------------------------------*
	,@(IF undefined-class-components *blank-line-item*)
	,@(IF undefined-class-components *blank-line-item*)
	,@(IF undefined-class-components
	      `(((:font 1 "3Undefined components of class *")
		 (:item1 instance ,(allocate-data 'show-clos-class class))
		 (:font 1 "3:*")))
	      nil)
	,@(LOOP for undefined in undefined-class-components
	        append `(((:item1 instance
			    ,(allocate-data 'show-undefined-clos-class
					    (FIRST undefined)))
			  (:font 3 "3 of class *")
			  (:item1 instance
				  ,(show-a-fl-or-cl (SECOND undefined))))))
;1; ------------------------------*
	,@(IF unsatisfied-flavors *blank-line-item*)
	,@(IF unsatisfied-flavors *blank-line-item*)
	,@(IF unsatisfied-flavors
	      `(((:font 1 "3Unsatisfied required flavors of class *")
		 (:item1 instance ,(allocate-data 'show-clos-class class))
		 (:font 1 "3:*")))
	      nil)
	,@(LOOP for unsatisfied in unsatisfied-flavors
	        append `(((:item1 instance
			   ,(IF (GET (FIRST unsatisfied) 'si::flavor)
				(allocate-data
				  'show-flavor
				  (GET (FIRST unsatisfied) 'si::flavor))
				(allocate-data
				  'show-undefined-flavor (FIRST unsatisfied))))
			  (:font 3 "3 for flavor *")
			  (:item1 instance
			   ,(allocate-data 'show-flavor (SECOND unsatisfied))))))
;1; ------------------------------*
	,@(IF unsatisfied-methods *blank-line-item*)
	,@(IF unsatisfied-methods *blank-line-item*)
	,@(IF unsatisfied-methods
	      `(((:font 1 "3Unsatisfied required methods of class *")
		 (:item1 instance ,(allocate-data 'show-clos-class class))
		 (:font 1 "3:*")))
	      nil)
	,@(LOOP for unsatisfied in unsatisfied-methods
	        append `(((:font 1 ,(FORMAT nil "3~S*" (FIRST unsatisfied)))
			  (:font 3 "3 for flavor *")
			  (:item1 instance
			   ,(allocate-data 'show-flavor (SECOND unsatisfied))))))
;1; ------------------------------*
	,@(IF unsatisfied-ivs *blank-line-item*)
	,@(IF unsatisfied-ivs *blank-line-item*)
	,@(IF unsatisfied-ivs
	      `(((:font 1 "3Unsatisfied required instance variables of class *")
		 (:item1 instance ,(allocate-data 'show-clos-class class))
		 (:font 1 "3:*")))
	      nil)
	,@(LOOP for unsatisfied in unsatisfied-ivs
	        append `(((:font 1 ,(FORMAT nil "3~S*" (FIRST unsatisfied)))
			  (:font 3 "3 for flavor *")
			  (:item1 instance
			   ,(allocate-data 'show-flavor (SECOND unsatisfied))))))
;1; ------------------------------*
        ,@(IF shadowed-clos-methods *blank-line-item*)
	,@(IF shadowed-clos-methods *blank-line-item*)
	,@(IF shadowed-clos-methods
	      `(((:font 1
		 "3Primary CLOS methods of component classes shadowed by class *")
		 (:item1 instance ,(allocate-data 'show-clos-class class))
		 (:font 1 "3:*")))
	      nil)
	,@(LOOP for shadow in shadowed-clos-methods
	        append `(((:item1 instance
			   ,(allocate-data 'show-clos-method (SECOND shadow))
			   print-unpadded-method)
			  (:font 3 "3 shadowed by  *")
			  (:item1 instance
			   ,(allocate-data 'show-clos-method (FIRST shadow))
			   print-unpadded-method))))
        ,@(IF shadowed-methods *blank-line-item*)
	,@(IF shadowed-methods *blank-line-item*)
	,@(IF shadowed-methods
	      `(((:font 1
	      "3Primary Flavors methods of component flavors shadowed by class *")
		 (:item1 instance ,(allocate-data 'show-clos-class class))
		 (:font 1 "3:*")))
	      nil)
	,@(LOOP for shadow in shadowed-methods
	        append `(((:item1 instance
				  ,(allocate-data 'show-method
						  (FOURTH (SECOND shadow))))
			  (:font 3 "3 of flavor *")
			  (:item1 instance
				  ,(allocate-data 'show-flavor (THIRD shadow)))
			  (:font 3 "3 shadowed by flavor *")
			  (:item1 instance
				 ,(allocate-data 'show-flavor (FIRST shadow))))))
;1; ---------------------------------*
       )
      `(:font fonts:hl12bi :string ,(FORMAT nil "3~A's Debug data*" class-name)))))

;1-------------------------------------------------------------------------------*

;1;; Patches *
;1;; =======*

;1; Stick the class inspector ion the flavor inspector system key.*
(IF (clos-p)
    (add-system-key #\o 'flavor-inspector
     "3Flavor/Class Inspector -- A utility for examining the structure of flavors and CLOS classes.*")
    (add-system-key #\o 'flavor-inspector
     "3Flavor Inspector -- A utility for examining the structure of flavors.*"))

(DEFMETHOD 4(flavor-inspector :inspect-object*) (object)
"2Is passed a symbol that names something that we want to inspect.  This is
 inspected as a flavor or as a class as appropriate.*"
  (CHECK-TYPE object symbol)
  (LET ((thing (inspect-real-value
		 (IF (GET object 'si::flavor)
		     `(:value ,(allocate-data 'show-flavor
					      (GET object 'si::flavor)) ,history)
		     (IF (class-named-safe object t)
			 `(:value ,(allocate-data
				     'show-clos-class
				     (class-named-safe object)) ,history)
			 (FERROR nil (IF (clos-p)
					 "3~S is not a flavor or class.*"
					 "3~S is not a flavor.*")))))))
    ;1; First flush item we will be inspecting*
    (inspect-flush-from-history thing history)
    (SEND history :append-item thing)
    (update-panes)))

;1**************
;1 TAC 08-04-89 - better version of this GENERAL-INSPECTOR*
;1(defun inspect-flavor (&optional (object nil objp))*

(DEFUN 4read-flavor-name* ()
"2Reads a flavor or class name from the user.*"
  (DECLARE (:self-flavor ucl::basic-command-loop))
  (LET ((ucl::typein-modes '(flavor-names class-names))
	(ucl::command-loop-typein? self)
	flavor-name)
    (DECLARE (SPECIAL ucl::typein-modes ucl::command-loop-typein?))
    (SEND self :handle-prompt t (IF (clos-p)
				    "3Flavor\/Class name: *"
				    "3Flavor name: *"))
    (SETQ flavor-name (sys::internal-read-form-or-implicit-list))
    (COND
      ((AND (SYMBOLP flavor-name)
            (OR (GET flavor-name 'si::flavor)
		(class-named-safe flavor-name)))
       (SEND self :handle-prompt)
       flavor-name)
      (t
       (FORMAT t "3** ~s is not a defined flavor or class*" flavor-name)
       (SEND self :handle-prompt)
       (THROW 'ucl::command-abort nil)))))

;1-------------------------------------------------------------------------------*

(DEFFLAVOR 4flavor-inspector* () (basic-inspect-frame)
  (:default-init-plist
    :active-command-tables '(flavor-inspector-cmd-table)
    :all-command-tables '(flavor-inspector-cmd-table)
    :menu-panes '((menu flavor-inspector-menu))
    :typein-modes 
    ;1; Modded here by JPR. *
    (IF (clos-p)
	'(method-specs class-instance class-names clos-method-specs
          flavor-instance flavor-names ucl::command-names)
	'(method-specs flavor-instance flavor-names ucl::command-names))
    :basic-help '(fi-doc-cmd)
    ;1; Modded here by JPR.*
    :prompt (IF (clos-p) "3Flavor\/Class\/Method: *" "3Flavor\/Method: *")
    ;1; Activate the special handling of instances of TV:INSPECTION-DATA.*
    ;1; This hack keeps the inspector code from treating mouse-sensitive blips*
    ;1; containing TV:INSPECTION-DATA instances as normal Lisp objects to inspect*
    ;1; and lets the instances dictate most inspector actions, such as*
    ;1; who-line-documentation when mouse is over the printed representation*
    ;1; of the instance, mouse button operations when it is clicked upon, and*
    ;1; item generation when the blip is inspected.*
    :inspection-data-active? t))

(DEFUN 4flavor-inspector-panes* ()
"2Pulled out of the :before :init method to make it a little more modular.*"
  (LIST `(interactor
	   inspector-interaction-pane
	   :label nil
	   :more-p nil
	   ;1:IO-BUFFER ,IOBUFF*
	   :font-map  ,(LIST (FIRST *inspector-font-map*)
			     (SECOND *inspector-font-map*))
	   :who-line-message
 "3To inspect a flavoror class, type its name.  To inspect a method, type <flavor name>
<method name>
Press HELP for a help menu, META-HELP for help on typed expressions.  R2: System Menu.*")
	`(history inspect-history-window  ;1-WITH-MARGIN-SCROLLING*
		  :line-area-mouse-doc
		  (:mouse-l-1 "3Inspect the indicated data*"
			      :mouse-m-1 "3Remove it from the Flavor Inspector*")
		  :normal-mouse-documentation
		  (:mouse-l-1 "3Select data to inspect*"
			      :mouse-m-2 "3Lock/Unlock inspector pane*"
			      :mouse-r-2 "3System Menu*"))
	`(menu inspector-menu-pane)))

(DEFUN 4flavor-inspector-constraints* (inspectors noi)
"2Pulled out of the :before :init method to make it a little more modular.*"
  `((:three-panes ,(REVERSE `(interactor menu-history ,@inspectors))
		  ((interactor 4 :lines))
		  ((menu-history
		     :horizontal (3 :lines history)
		     (menu history)
		     ((menu :ask :pane-size))
		     ((history :even))))
		  ,(MAPCAR #'(lambda (name1)
			       `(,name1 :limit (1 36 :lines)
				 ,(/ 0.3s0 (1- noi)) :lines))
			   (CDR inspectors))
		  ((,(CAR inspectors) :even)))
    (:one-pane (,(CAR inspectors) menu-history interactor)
	       ((interactor 4 :lines))
	       ((menu-history
		  :horizontal (3 :lines history)
		  (menu history)
		  ((menu :ask :pane-size))
		  ((history :even))))
	       ((,(CAR inspectors) :even)))
    (:two-horizontal-panes
      ,(REVERSE `(interactor menu-history inspector-2 inspector-1))
      ((interactor 4 :lines))
      ((menu-history :horizontal (3 :lines history) (menu history)
		     ((menu :ask :pane-size))
		     ((history :even))))
      ((inspector-1 0.5))
      ((inspector-2 :even)))
    (:two-vertical-panes
      ,(REVERSE `(interactor menu-history side-by-side))
      ((interactor 4 :lines))
      ((menu-history :horizontal (3 :lines history)
		     (menu history)
		     ((menu :ask :pane-size))
		     ((history :even))))
      ((side-by-side :horizontal (:even)
		     (inspector-2 inspector-1)
		     ((inspector-1 0.5))
		     ((inspector-2 :even)))))
    (:debug (,(CAR inspectors) menu-history interactor)
	    ((interactor 45 :lines))
	    ((menu-history
	       :horizontal (3 :lines history)
	       (menu history)
	       ((menu :ask :pane-size))
	       ((history :even))))
	    ((,(CAR inspectors) :even)))))

(DEFMETHOD 4(flavor-inspector :before :init*) (plist)
 ;1; Specify our panes and constraints.  This differs from*
 ;1; (TV:INSPECT-FRAME :BEFORE :INIT) only in some of the who-line messages we*
 ;1; provide, which are specific to flavor inspectors.*
  (UNLESS inspectors ;1; It didn't use to have this test. JPR*
  (LET ((noi (OR (GET plist :number-of-inspectors) 3)))
    (SETQ panes (flavor-inspector-panes))
    ;1; Add an inspector to PANES, taking into account the number of inspector*
    ;1; panes requested.  The first inspector is given a typeout pane.*
    ;1; Also initialize INSPECTORS.*
    (DOTIMES (i noi)
      (LET ((name1 (INTERN (FORMAT () "3INSPECTOR-~D*" i) "3TV*")))
	(PUSH `(,name1 ,(IF (= i (1- noi))
			    'inspect-window-with-typeout
			    'inspect-window)
                ;1; Otherwise we get "More Object Above", etc.*
                :current-object-who-line-message
		,(FUNCTION (lambda (current-object)
			     (COND
			       ((EQUAL current-object '(nil))
 "3Flavor/Class Inspection Pane.  To inspect a flavor, type its name.  To inspect a method, type <flavor name> <method name>
Press HELP for a help menu, META-HELP for help on typed expressions.  R2: System Menu.*")
			       ((TYPEP current-object 'flavor-operation-mixin)
				`(:mouse-l-1
				   "3Select data to inspect*"
				   :mouse-m-1 "3Help on currently displayed data*"
				   :mouse-m-2 "3Lock/Unlock inspector pane*"
				   :mouse-r-1
				    ,(FORMAT
				       ()
				       (IF (clos-p)
					"3Menu of operations on flavor\/class ~s*"
					   "3Menu of operations on flavor ~s*")
				       (flavor-or-class-name
					 (SEND current-object :data)))))
			       (t '(:mouse-l-1 "3Choose an item to inspect*"))))))
              panes)
	(PUSH name1 inspectors)))
    (SETQ constraints (flavor-inspector-constraints inspectors noi)))))

(DEFCOMMAND 4(flavor-inspector :options-menu*) ()  
   '(:keys #\Mouse-r 
     :description
     "3A menu of options for the selected (moused) inspection pane.*")
   (IF (MEMBER (THIRD ucl::kbd-input) inspectors :test #'EQ)
     (LET ((inspection-data (SEND (THIRD ucl::kbd-input) :current-object))
	   *flavor-data*)
       (DECLARE (SPECIAL *flavor-data*))
       (COND
	 ((EQUAL inspection-data '(nil))
	  (SEND self :format-message "3MOUSE R is inactive when the inspection pane is empty.*"))
	 ;1; JPR.*
	 ((AND (TYPEP inspection-data 'class-operation-mixin)
	       (class-p-safe (SEND inspection-data :data)))
	  (SETQ *flavor-data* (SEND inspection-data :data))
	  (LET ((call-edit nil))
                   (DECLARE (SPECIAL *flavor-data* call-edit))
                   (w:menu-choose
		     *class-options-menu*
		     :label (FORMAT nil "3Operations on ~S*"
				    (class-name-safe *flavor-data*))
		     :scrolling-p nil)
		   (IF call-edit
		       (ED (class-name-safe *flavor-data*)))))
	 ((AND (TYPEP inspection-data 'flavor-operation-mixin)
	       (TYPEP (SEND inspection-data :data) 'si::flavor))
	  (SETQ *flavor-data* (SEND inspection-data :data))
	  (LET ((call-edit nil))
                   (DECLARE (SPECIAL *flavor-data* call-edit))
                   (w:menu-choose
		     *flavor-options-menu*
		     :label (FORMAT nil "3Operations on ~S*"
				    (si::flavor-name *flavor-data*))
		     :scrolling-p nil)
		   (IF call-edit
		       (ED (si::flavor-name *flavor-data*)))
		   ))))
     (BEEP)))

;1; This is rather like the All-Flavors command.  It has a short name because of the menu.*
(DEFCOMMAND 4(flavor-inspector :all-fl&cl*) ()
  '(:description "3Display all flavor or class names in an inspection frame*"
    :documentation "3...permits user to select a flavor to inspect...*"
    :keys #\Super-a)
  (LET ((flavors (inspect-real-value
		   `(:value ,(allocate-data 'show-all-flavors-and-classes
					    'IGNORE) ,history))))
    ;1; Might not work since not EQ*
    (inspect-flush-from-history flavors history)
    (SEND history :append-item flavors)
    (update-panes)
    ;1; We don't want our result to be printed.*
    (SETQ ucl:inhibit-results-print? t)))


;1; Now we can build the command tables.*
(BUILD-COMMAND-TABLE 'flavor-inspector-cmd-table 'flavor-inspector
  '(:all-fl&cl
     :help-on-syntax
     :help-on-inspected-data
     :end-cmd
     :options-menu
     :trace-method
     :fi-doc-cmd
     config-toggle-cmd
     mode
     ;1; These are Inspector commands we are able to borrow.*
     delete-all-cmd
     refresh-cmd
     page-up-cmd
     page-down-cmd
     page-to-top
     page-to-bottom
     break-cmd)
  :init-options '(:name "3Flavor Inspector Commands*"))

(BUILD-MENU 'flavor-inspector-menu 'flavor-inspector
  :item-list-order
  '(:help-on-syntax
    :all-fl&cl
    :trace-method
    :end-cmd
    :fi-doc-cmd
    delete-all-cmd
    refresh-cmd
    page-up-cmd
    page-down-cmd
    break-cmd
    mode
    config-toggle-cmd))

;1-------------------------------------------------------------------------------*

(DEFMETHOD 4(show-method-details :middle-button-result*) ()
"2Return the method itself.*"
  (SECOND aux-data))

(DEFMETHOD 4(show-method-details :generate-item*) ()
"2This is a redefined version of the origonal method which takes advantage of the
 extensions to ivars-and-messages-in-method that JPR made.*" 
 (LET (not-available)
   (VALUES
     (MULTIPLE-VALUE-BIND
       (referenced-ivars referenced-keywords problem
	referenced-functions referenced-generic-functions ignore ignore
	locals specials-referenced specials-bound)
         (ivars-and-messages-in-method (CAR aux-data))
       (WHEN problem
         (SETQ not-available (IF (EQ problem :wrapper)
                                 '(((:font 2 "3 not available for wrappers*")))
                                 '(((:font 2 "3 not available for interpreted methods*"))))))
       (MULTIPLE-VALUE-BIND (args returned-values)
           ;1; Wrappers and interpreted methods have a method table entry format different from the norm.*
           ;1; Wrappers' entries are (<spec> (MACRO . <fef>)...).  Interpreted methods are (<spec> (NAME-LAMBA <spec> <arglist> ...))*
           (COND ((EQ problem :wrapper) (ARGLIST (CDADR aux-data)))
                 ((EQ problem :interpreted) (CDR (THIRD (CADR aux-data)))) ;1;Take CDR to get rid of SI:.OPERATION. arg.*
                 (t (CDR (ARGLIST (CADR aux-data))))) ;1; Take CDR to get rid of SI:.OPERATION. arg.*
         `(,*blank-line-item*
           ((:font 1 "3Details of *")
            (:item1 instance ,(allocate-data 'show-method-details data aux-data)))
           ,*blank-line-item*
           ((:font 1 "3Source File:               *")
	   ;1; Changed by DAN to check for a null source-file property (Third aux-data) for the method,*
	   ;1; since the method may have been typed in interactively or generated automatically.*
	   ,(IF (GETF (THIRD aux-data) :source-file-name)
		(LET ((sf (GETF (THIRD aux-data) :source-file-name)))
		     (FORMAT nil "3~a*" (SEND (IF (CONSP sf) (CADR (ASSOC 'DEFUN sf :test #'EQ)) sf) :string-for-printing)))
		(FORMAT nil "3Not Defined*")))
           ((:font 1 "3Method combination type:   *")
            ,(LET ((method-entry (ASSOC (OR (FOURTH (CAR aux-data)) (THIRD (CAR aux-data)))
                                        (si::flavor-method-table data) :test #'EQ)))
               (IF (CADR method-entry)
                   `("3~S~@[ ~S~]*" ,(CADR method-entry) ,(CADDR method-entry))
                   "3:DAEMON (the default)*")))
           (,(IF returned-values
                 '(:font 1 "3Arglist  Returned Values: *")
                 '(:font 1 "3Arglist:                   *"))
            ("3~:[~*()~;~S~]*" ,args ,args)
            ,@(WHEN returned-values
                `(("3  ~S*" ,returned-values))))
           ,*blank-line-item*
           ((:font 1 "3Documentation:*"))
           ,@(LET ((doc (DOCUMENTATION (CADR aux-data))))
               (IF (AND doc (NOT (EQUAL "" doc)))
                   (break-string-into-lines doc)
                   *no-items*))
           ,*blank-line-item*
           ((:font 1 "3Referenced Instance Variables:*"))
	   ,@(referenced-instance-variables-details
	       (SECOND aux-data) referenced-ivars)
	   ,*blank-line-item*
	   ((:font 1 "3Referenced Keywords (possibly messages passed):*"))
	   ,@(referenced-keywords-details referenced-keywords)
	   ,*blank-line-item*
	   ((:font 1 "3Referenced Generic Functions:*"))
	   ,@(referenced-generic-functions-details
		referenced-generic-functions)
	   ,*blank-line-item*
	   ((:font 1 "3Referenced Functions:*"))
	   ,@(referenced-functions-details referenced-functions)
	   ,*blank-line-item*
	   ((:font 1 "3Locals:*"))
	   ,@(locals-details locals)
	   ,*blank-line-item*
	   ((:font 1 "3Referenced Specials:*"))
	   ,@(referenced-specials-details specials-referenced)
	   ,*blank-line-item*
	   ((:font 1 "3Specials Bound:*"))
	   ,@(bound-specials-details specials-bound)
	   ,*blank-line-item*
	   ((:font 1 "3Macros Expanded:*"))
	   ,@(macros-expanded-details (FIRST aux-data))
	   ,*blank-line-item*
	   ((:font 1 "3Interpreted Definition:*"))
	   ,@(interpreted-definition-details (SECOND aux-data))
	)))
     `(:font fonts:hl12bi :string ,(FORMAT nil "3Method~{ ~s~}*" (CDAR aux-data))))))

(DEFUN 4coerce-to-flavor* (x)
"2If we've got a class then make it into a flavor for flavor inspection purposes.*"
  (IF (class-p-safe x)
      (GET (class-name-safe x) 'si::flavor)
      x))

(DEFMETHOD 4(show-instance-variable :handle-mouse-click*) (blip flavor-inspector)
  (IF (NOT (MEMBER (FOURTH blip) '(#\Mouse-l #\Mouse-m) :test #'EQ))
    (BEEP)
    (SEND flavor-inspector :inspect-thing
	  'show-methods-referencing-instance-variable
       (IF (EQL (FOURTH blip) #\Mouse-l)
	   ;1; Make sure that this is a flavor.  It could be a class too.*
	   (coerce-to-flavor (SEND (SEND (THIRD blip) :current-object) :data))
	   (GET (SEND flavor-inspector :funcall-inside-yourself
		      (FUNCTION read-flavor-name))
		'si::flavor))
       data)))

(DEFMETHOD 4(show-instance-variable :middle-button-result*) ()
  "2Just return the symbol that names the slot.*"
  data)
